/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.optimizer.IrExpressionOptimizer;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.ExpressionSymbolInliner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PushFilterIntoValues
implements Rule<FilterNode> {
    private static final Capture<ValuesNode> VALUES = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.values().matching(PushFilterIntoValues::isSupportedValues).capturedAs(VALUES)));
    private final PlannerContext plannerContext;

    public PushFilterIntoValues(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
        Set<Symbol> predicateSymbols;
        ValuesNode valuesNode = (ValuesNode)captures.get(VALUES);
        if (valuesNode.getRows().orElseThrow().size() > SystemSessionProperties.getPushFilterIntoValuesMaxRowCount(context.getSession())) {
            return Rule.Result.empty();
        }
        Expression predicate = node.getPredicate();
        if (!DeterminismEvaluator.isDeterministic(predicate)) {
            return Rule.Result.empty();
        }
        if (valuesNode.getRows().orElseThrow().isEmpty()) {
            return Rule.Result.ofPlanNode(valuesNode);
        }
        if (valuesNode.getRows().orElseThrow().stream().anyMatch(row -> !DeterminismEvaluator.isDeterministic(row))) {
            return Rule.Result.empty();
        }
        Set valuesExpressionsSymbols = (Set)valuesNode.getRows().orElseThrow().stream().map(SymbolsExtractor::extractUnique).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        if (!valuesExpressionsSymbols.isEmpty()) {
            return Rule.Result.empty();
        }
        ImmutableSet valuesOutputSymbols = ImmutableSet.copyOf(valuesNode.getOutputSymbols());
        if (!valuesOutputSymbols.containsAll(predicateSymbols = SymbolsExtractor.extractUnique(predicate))) {
            return Rule.Result.empty();
        }
        ImmutableList.Builder filteredRows = ImmutableList.builder();
        boolean optimized = false;
        boolean keepFilter = false;
        for (Expression expression : valuesNode.getRows().orElseThrow()) {
            Row row2 = (Row)expression;
            ImmutableMap.Builder mapping = ImmutableMap.builder();
            for (int i = 0; i < valuesNode.getOutputSymbols().size(); ++i) {
                mapping.put((Object)valuesNode.getOutputSymbols().get(i), (Object)row2.items().get(i));
            }
            Expression rewrittenPredicate = ExpressionSymbolInliner.inlineSymbols((Map<Symbol, ? extends Expression>)mapping.buildOrThrow(), predicate);
            Optional<Expression> optimizedPredicate = IrExpressionOptimizer.newOptimizer(this.plannerContext).process(rewrittenPredicate, context.getSession(), (Map<Symbol, Expression>)ImmutableMap.of());
            if (optimizedPredicate.isPresent() && optimizedPredicate.get().equals(Booleans.TRUE)) {
                filteredRows.add((Object)row2);
                continue;
            }
            if (optimizedPredicate.isPresent() && (optimizedPredicate.get().equals(Booleans.FALSE) || optimizedPredicate.get().equals(Booleans.NULL_BOOLEAN))) {
                optimized = true;
                continue;
            }
            filteredRows.add((Object)row2);
            keepFilter = true;
        }
        if (!optimized && keepFilter) {
            return Rule.Result.empty();
        }
        ValuesNode optimizedValues = new ValuesNode(valuesNode.getId(), valuesNode.getOutputSymbols(), (List<Expression>)filteredRows.build());
        if (keepFilter) {
            return Rule.Result.ofPlanNode(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)optimizedValues)));
        }
        return Rule.Result.ofPlanNode(optimizedValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSupportedValues(ValuesNode valuesNode) {
        if (!valuesNode.getRows().isPresent()) return false;
        if (!valuesNode.getRows().get().stream().allMatch(Row.class::isInstance)) return false;
        return true;
    }
}

