/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.metadata.TableHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;

@Immutable
public class TableUpdateNode
extends PlanNode {
    private final TableHandle target;
    private final Symbol output;

    @JsonCreator
    public TableUpdateNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="target") TableHandle target, @JsonProperty(value="output") Symbol output) {
        super(id);
        this.target = Objects.requireNonNull(target, "target is null");
        this.output = Objects.requireNonNull(output, "output is null");
    }

    @JsonProperty
    public TableHandle getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getOutput() {
        return this.output;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of((Object)this.output);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren should be empty");
        return this;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableUpdate(this, context);
    }
}

