/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler2;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkInstrumenterFactory;
import io.opentelemetry.instrumentation.awssdk.v1_11.AwsSdkTelemetryBuilder;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsProcessRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.SqsReceiveRequest;
import io.opentelemetry.instrumentation.awssdk.v1_11.TracingRequestHandler;
import java.util.List;

public class AwsSdkTelemetry {
    private final Instrumenter<Request<?>, Response<?>> requestInstrumenter;
    private final Instrumenter<SqsReceiveRequest, Response<?>> consumerReceiveInstrumenter;
    private final Instrumenter<SqsProcessRequest, Response<?>> consumerProcessInstrumenter;
    private final Instrumenter<Request<?>, Response<?>> producerInstrumenter;
    private final Instrumenter<Request<?>, Response<?>> dynamoDbInstrumenter;

    public static Context getOpenTelemetryContext(Request<?> request) {
        return (Context)request.getHandlerContext(TracingRequestHandler.CONTEXT);
    }

    public static AwsSdkTelemetry create(OpenTelemetry openTelemetry) {
        return AwsSdkTelemetry.builder(openTelemetry).build();
    }

    public static AwsSdkTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new AwsSdkTelemetryBuilder(openTelemetry);
    }

    AwsSdkTelemetry(OpenTelemetry openTelemetry, List<String> capturedHeaders, boolean captureExperimentalSpanAttributes, boolean messagingReceiveInstrumentationEnabled) {
        AwsSdkInstrumenterFactory instrumenterFactory = new AwsSdkInstrumenterFactory(openTelemetry, capturedHeaders, captureExperimentalSpanAttributes, messagingReceiveInstrumentationEnabled);
        this.requestInstrumenter = instrumenterFactory.requestInstrumenter();
        this.consumerReceiveInstrumenter = instrumenterFactory.consumerReceiveInstrumenter();
        this.consumerProcessInstrumenter = instrumenterFactory.consumerProcessInstrumenter();
        this.producerInstrumenter = instrumenterFactory.producerInstrumenter();
        this.dynamoDbInstrumenter = instrumenterFactory.dynamoDbInstrumenter();
    }

    public RequestHandler2 newRequestHandler() {
        return new TracingRequestHandler(this.requestInstrumenter, this.consumerReceiveInstrumenter, this.consumerProcessInstrumenter, this.producerInstrumenter, this.dynamoDbInstrumenter);
    }
}

