/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.AlluxioURI;
import io.trino.filesystem.Location;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Optional;

public class AlluxioUtils {
    private AlluxioUtils() {
    }

    public static Location convertToLocation(String path, String mountRoot) {
        Objects.requireNonNull(path, "path is null");
        if (path.isEmpty()) {
            return Location.of((String)"");
        }
        if (path.startsWith("alluxio://")) {
            return Location.of((String)path);
        }
        String schema = "alluxio://";
        if (path.startsWith("/")) {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        Object mountRootWithSlash = mountRoot;
        if (!mountRoot.endsWith("/")) {
            mountRootWithSlash = mountRoot + "/";
        }
        return Location.of((String)(schema + (String)mountRootWithSlash + path));
    }

    public static String getAlluxioBase(String path) {
        Objects.requireNonNull(path, "path is null");
        if (!path.startsWith("alluxio://")) {
            throw new IllegalArgumentException("path is not an alluxio://");
        }
        int index = path.indexOf(47, "alluxio://".length());
        return path.substring(0, index);
    }

    public static String simplifyPath(String path) {
        String[] segments;
        ArrayDeque<String> deque = new ArrayDeque<String>();
        for (String segment : segments = path.split("/")) {
            if (segment.isEmpty() || segment.equals(".")) continue;
            if (segment.equals("..")) {
                if (deque.isEmpty()) continue;
                deque.pollLast();
                continue;
            }
            deque.offerLast(segment);
        }
        StringBuilder simplifiedPath = new StringBuilder();
        for (String dir : deque) {
            simplifiedPath.append(dir).append("/");
        }
        if (!path.endsWith("/") && simplifiedPath.length() > 0) {
            simplifiedPath.setLength(simplifiedPath.length() - 1);
        }
        return simplifiedPath.length() == 0 ? "" : simplifiedPath.toString();
    }

    public static AlluxioURI convertToAlluxioURI(Location location, String mountRoot) {
        Optional scheme = location.scheme();
        if (scheme.isPresent() && !((String)scheme.get()).equals("alluxio")) {
            return new AlluxioURI(location.toString());
        }
        String path = location.path();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!((String)mountRoot).endsWith("/")) {
            mountRoot = (String)mountRoot + "/";
        }
        return new AlluxioURI((String)mountRoot + path);
    }
}

