/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

import com.google.common.base.Preconditions;
import io.trino.tpcds.random.RandomNumberStream;
import io.trino.tpcds.random.RandomValueGenerator;

public final class Permutations {
    private Permutations() {
    }

    public static int[] makePermutation(int size, RandomNumberStream stream) {
        int i;
        int[] numberSet = new int[size];
        for (i = 0; i < numberSet.length; ++i) {
            numberSet[i] = i;
        }
        for (i = 0; i < numberSet.length; ++i) {
            int index = RandomValueGenerator.generateUniformRandomInt(0, size - 1, stream);
            int temp = numberSet[i];
            numberSet[i] = numberSet[index];
            numberSet[index] = temp;
        }
        return numberSet;
    }

    public static int getPermutationEntry(int[] permuation, int index) {
        Preconditions.checkArgument((index >= 1 ? 1 : 0) != 0, (String)"index is not greater than or equal to 1: %s", (int)index);
        return permuation[index - 1] + 1;
    }
}

