/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row;

import com.google.common.collect.Lists;
import io.trino.tpcds.generator.StoreSalesGeneratorColumn;
import io.trino.tpcds.row.TableRowWithNulls;
import io.trino.tpcds.type.Pricing;
import java.util.List;

public class StoreSalesRow
extends TableRowWithNulls {
    private final long ssSoldDateSk;
    private final long ssSoldTimeSk;
    private final long ssSoldItemSk;
    private final long ssSoldCustomerSk;
    private final long ssSoldCdemoSk;
    private final long ssSoldHdemoSk;
    private final long ssSoldAddrSk;
    private final long ssSoldStoreSk;
    private final long ssSoldPromoSk;
    private final long ssTicketNumber;
    private final Pricing ssPricing;

    public StoreSalesRow(long nullBitMap, long ssSoldDateSk, long ssSoldTimeSk, long ssSoldItemSk, long ssSoldCustomerSk, long ssSoldCdemoSk, long ssSoldHdemoSk, long ssSoldAddrSk, long ssSoldStoreSk, long ssSoldPromoSk, long ssTicketNumber, Pricing ssPricing) {
        super(nullBitMap, StoreSalesGeneratorColumn.SS_SOLD_DATE_SK);
        this.ssSoldDateSk = ssSoldDateSk;
        this.ssSoldTimeSk = ssSoldTimeSk;
        this.ssSoldItemSk = ssSoldItemSk;
        this.ssSoldCustomerSk = ssSoldCustomerSk;
        this.ssSoldCdemoSk = ssSoldCdemoSk;
        this.ssSoldHdemoSk = ssSoldHdemoSk;
        this.ssSoldAddrSk = ssSoldAddrSk;
        this.ssSoldStoreSk = ssSoldStoreSk;
        this.ssSoldPromoSk = ssSoldPromoSk;
        this.ssTicketNumber = ssTicketNumber;
        this.ssPricing = ssPricing;
    }

    @Override
    public List<String> getValues() {
        return Lists.newArrayList((Object[])new String[]{this.getStringOrNullForKey(this.ssSoldDateSk, StoreSalesGeneratorColumn.SS_SOLD_DATE_SK), this.getStringOrNullForKey(this.ssSoldTimeSk, StoreSalesGeneratorColumn.SS_SOLD_TIME_SK), this.getStringOrNullForKey(this.ssSoldItemSk, StoreSalesGeneratorColumn.SS_SOLD_ITEM_SK), this.getStringOrNullForKey(this.ssSoldCustomerSk, StoreSalesGeneratorColumn.SS_SOLD_CUSTOMER_SK), this.getStringOrNullForKey(this.ssSoldCdemoSk, StoreSalesGeneratorColumn.SS_SOLD_CDEMO_SK), this.getStringOrNullForKey(this.ssSoldHdemoSk, StoreSalesGeneratorColumn.SS_SOLD_HDEMO_SK), this.getStringOrNullForKey(this.ssSoldAddrSk, StoreSalesGeneratorColumn.SS_SOLD_ADDR_SK), this.getStringOrNullForKey(this.ssSoldStoreSk, StoreSalesGeneratorColumn.SS_SOLD_STORE_SK), this.getStringOrNullForKey(this.ssSoldPromoSk, StoreSalesGeneratorColumn.SS_SOLD_PROMO_SK), this.getStringOrNullForKey(this.ssTicketNumber, StoreSalesGeneratorColumn.SS_TICKET_NUMBER), this.getStringOrNull(this.ssPricing.getQuantity(), StoreSalesGeneratorColumn.SS_PRICING_QUANTITY), this.getStringOrNull(this.ssPricing.getWholesaleCost(), StoreSalesGeneratorColumn.SS_PRICING_WHOLESALE_COST), this.getStringOrNull(this.ssPricing.getListPrice(), StoreSalesGeneratorColumn.SS_PRICING_LIST_PRICE), this.getStringOrNull(this.ssPricing.getSalesPrice(), StoreSalesGeneratorColumn.SS_PRICING_SALES_PRICE), this.getStringOrNull(this.ssPricing.getCouponAmount(), StoreSalesGeneratorColumn.SS_PRICING_COUPON_AMT), this.getStringOrNull(this.ssPricing.getExtSalesPrice(), StoreSalesGeneratorColumn.SS_PRICING_EXT_SALES_PRICE), this.getStringOrNull(this.ssPricing.getExtWholesaleCost(), StoreSalesGeneratorColumn.SS_PRICING_EXT_WHOLESALE_COST), this.getStringOrNull(this.ssPricing.getExtListPrice(), StoreSalesGeneratorColumn.SS_PRICING_EXT_LIST_PRICE), this.getStringOrNull(this.ssPricing.getExtTax(), StoreSalesGeneratorColumn.SS_PRICING_EXT_TAX), this.getStringOrNull(this.ssPricing.getCouponAmount(), StoreSalesGeneratorColumn.SS_PRICING_COUPON_AMT), this.getStringOrNull(this.ssPricing.getNetPaid(), StoreSalesGeneratorColumn.SS_PRICING_NET_PAID), this.getStringOrNull(this.ssPricing.getNetPaidIncludingTax(), StoreSalesGeneratorColumn.SS_PRICING_NET_PAID_INC_TAX), this.getStringOrNull(this.ssPricing.getNetProfit(), StoreSalesGeneratorColumn.SS_PRICING_NET_PROFIT)});
    }

    public long getSsTicketNumber() {
        return this.ssTicketNumber;
    }

    public long getSsSoldItemSk() {
        return this.ssSoldItemSk;
    }

    public long getSsSoldCustomerSk() {
        return this.ssSoldCustomerSk;
    }

    public long getSsSoldDateSk() {
        return this.ssSoldDateSk;
    }

    public Pricing getSsPricing() {
        return this.ssPricing;
    }
}

