/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.Nulls;
import io.trino.tpcds.Scaling;
import io.trino.tpcds.Session;
import io.trino.tpcds.SlowlyChangingDimensionUtils;
import io.trino.tpcds.Table;
import io.trino.tpcds.generator.InventoryGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.InventoryRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Date;

public class InventoryRowGenerator
extends AbstractRowGenerator {
    public InventoryRowGenerator() {
        super(Table.INVENTORY);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.INVENTORY, this.getRandomNumberStream(InventoryGeneratorColumn.INV_NULLS));
        int index = (int)rowNumber - 1;
        Scaling scaling = session.getScaling();
        long itemCount = scaling.getIdCount(Table.ITEM);
        long invItemSk = (long)index % itemCount + 1L;
        long warehouseCount = scaling.getIdCount(Table.WAREHOUSE);
        long invWarehouseSk = (long)(index /= (int)itemCount) % warehouseCount + 1L;
        long invDateSk = Date.JULIAN_DATE_MINIMUM + (index /= (int)warehouseCount) * 7;
        invItemSk = SlowlyChangingDimensionUtils.matchSurrogateKey(invItemSk, invDateSk, Table.ITEM, scaling);
        int invQuantityOnHand = RandomValueGenerator.generateUniformRandomInt(0, 1000, this.getRandomNumberStream(InventoryGeneratorColumn.INV_QUANTITY_ON_HAND));
        return new RowGeneratorResult(new InventoryRow(nullBitMap, invDateSk, invItemSk, invWarehouseSk, invQuantityOnHand));
    }
}

