/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.JoinKeyUtils;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.SlowlyChangingDimensionUtils;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.CategoriesDistribution;
import io.trino.tpcds.distribution.CategoryClassDistributions;
import io.trino.tpcds.distribution.EnglishDistributions;
import io.trino.tpcds.distribution.ItemCurrentPriceDistribution;
import io.trino.tpcds.distribution.ItemsDistributions;
import io.trino.tpcds.generator.ItemGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.ItemRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Decimal;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ItemRowGenerator
extends AbstractRowGenerator {
    private static final Decimal MIN_ITEM_MARKDOWN_PCT = new Decimal(30L, 2);
    private static final Decimal MAX_ITEM_MARKDOWN_PCT = new Decimal(90L, 2);
    private static final int ROW_SIZE_I_PRODUCT_NAME = 50;
    private static final int ROW_SIZE_I_ITEM_DESC = 200;
    private static final int ROW_SIZE_I_MANUFACT = 50;
    private static final int ROW_SIZE_I_FORMULATION = 20;
    private static final int I_PROMO_PERCENTAGE = 20;
    private Optional<ItemRow> previousRow = Optional.empty();

    public ItemRowGenerator() {
        super(Table.ITEM);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long newClassId;
        long nullBitMap = Nulls.createNullBitMap(Table.ITEM, this.getRandomNumberStream(ItemGeneratorColumn.I_NULLS));
        long iItemSk = rowNumber;
        List<Integer> managerIdRange = ItemsDistributions.pickRandomManagerIdRange(ItemsDistributions.IdWeights.UNIFIED, this.getRandomNumberStream(ItemGeneratorColumn.I_MANAGER_ID));
        long iManagerId = RandomValueGenerator.generateUniformRandomKey(managerIdRange.get(0).intValue(), managerIdRange.get(1).intValue(), this.getRandomNumberStream(ItemGeneratorColumn.I_MANAGER_ID));
        SlowlyChangingDimensionUtils.SlowlyChangingDimensionKey slowlyChangingDimensionKey = SlowlyChangingDimensionUtils.computeScdKey(Table.ITEM, rowNumber);
        String iItemId = slowlyChangingDimensionKey.getBusinessKey();
        long iRecStartDateId = slowlyChangingDimensionKey.getStartDate();
        long iRecEndDateId = slowlyChangingDimensionKey.getEndDate();
        boolean isNewBusinessKey = slowlyChangingDimensionKey.isNewBusinessKey();
        int fieldChangeFlags = (int)this.getRandomNumberStream(ItemGeneratorColumn.I_SCD).nextRandom();
        String iItemDesc = RandomValueGenerator.generateRandomText(1, 200, this.getRandomNumberStream(ItemGeneratorColumn.I_ITEM_DESC));
        if (this.previousRow.isPresent()) {
            iItemDesc = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getiItemDesc(), iItemDesc);
        }
        fieldChangeFlags >>= 1;
        List<Decimal> currentPriceRange = ItemCurrentPriceDistribution.pickRandomCurrentPriceRange(this.getRandomNumberStream(ItemGeneratorColumn.I_CURRENT_PRICE));
        Decimal iCurrentPrice = RandomValueGenerator.generateUniformRandomDecimal(currentPriceRange.get(0), currentPriceRange.get(1), this.getRandomNumberStream(ItemGeneratorColumn.I_CURRENT_PRICE));
        fieldChangeFlags >>= 1;
        Decimal markdown = RandomValueGenerator.generateUniformRandomDecimal(MIN_ITEM_MARKDOWN_PCT, MAX_ITEM_MARKDOWN_PCT, this.getRandomNumberStream(ItemGeneratorColumn.I_WHOLESALE_COST));
        Decimal iWholesaleCost = Decimal.multiply(iCurrentPrice, markdown);
        if (this.previousRow.isPresent()) {
            iWholesaleCost = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getiWholesaleCost(), iWholesaleCost);
        }
        fieldChangeFlags >>= 1;
        int iCategoryIndex = CategoriesDistribution.pickRandomIndex(this.getRandomNumberStream(ItemGeneratorColumn.I_CATEGORY));
        int iCategoryId = iCategoryIndex + 1;
        String iCategory = CategoriesDistribution.getCategoryAtIndex(iCategoryIndex);
        CategoryClassDistributions.CategoryClass categoryClass = CategoryClassDistributions.pickRandomCategoryClass(iCategoryIndex, this.getRandomNumberStream(ItemGeneratorColumn.I_CLASS));
        String iClass = categoryClass.getName();
        long iClassId = newClassId = categoryClass.getId();
        if (this.previousRow.isPresent()) {
            iClassId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getiClassId(), iClassId);
        }
        fieldChangeFlags >>= 1;
        int brandCount = categoryClass.getBrandCount();
        long iBrandId = rowNumber % (long)brandCount + 1L;
        String iBrand = RandomValueGenerator.generateWord((long)(iCategoryId * 10) + newClassId, 45, ItemsDistributions.BRAND_SYLLABLES_DISTRIBUTION);
        iBrand = iBrand + String.format(" #%d", iBrandId);
        iBrandId += ((long)(iCategoryId * 1000) + newClassId) * 1000L;
        if (this.previousRow.isPresent()) {
            iBrandId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getiBrandId(), iBrandId);
        }
        fieldChangeFlags >>= 1;
        int hasSize = CategoriesDistribution.getHasSizeAtIndex(iCategoryIndex);
        String iSize = ItemsDistributions.pickRandomSize(hasSize == 0 ? ItemsDistributions.SizeWeights.NO_SIZE : ItemsDistributions.SizeWeights.SIZED, this.getRandomNumberStream(ItemGeneratorColumn.I_SIZE));
        fieldChangeFlags >>= 1;
        List<Integer> manufactIdRange = ItemsDistributions.pickRandomManufactIdRange(ItemsDistributions.IdWeights.UNIFIED, this.getRandomNumberStream(ItemGeneratorColumn.I_MANUFACT_ID));
        long iManufactId = RandomValueGenerator.generateUniformRandomInt(manufactIdRange.get(0), manufactIdRange.get(1), this.getRandomNumberStream(ItemGeneratorColumn.I_MANUFACT_ID));
        if (this.previousRow.isPresent()) {
            iManufactId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getiManufactId(), iManufactId);
        }
        fieldChangeFlags >>= 1;
        String iManufact = RandomValueGenerator.generateWord(iManufactId, 50, EnglishDistributions.SYLLABLES_DISTRIBUTION);
        if (this.previousRow.isPresent()) {
            iManufact = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getiManufact(), iManufact);
        }
        fieldChangeFlags >>= 1;
        String iFormulation = RandomValueGenerator.generateRandomCharset("0123456789", 20, 20, this.getRandomNumberStream(ItemGeneratorColumn.I_FORMULATION));
        String color = ItemsDistributions.pickRandomColor(ItemsDistributions.ColorsWeights.SKEWED, this.getRandomNumberStream(ItemGeneratorColumn.I_FORMULATION));
        int position = RandomValueGenerator.generateUniformRandomInt(0, iFormulation.length() - color.length() - 1, this.getRandomNumberStream(ItemGeneratorColumn.I_FORMULATION));
        StringBuilder builder = new StringBuilder(iFormulation);
        builder.replace(position, color.length() + position, color);
        iFormulation = builder.toString();
        if (this.previousRow.isPresent()) {
            iFormulation = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getiFormulation(), iFormulation);
        }
        String iColor = ItemsDistributions.pickRandomColor(ItemsDistributions.ColorsWeights.SKEWED, this.getRandomNumberStream(ItemGeneratorColumn.I_COLOR));
        String iUnits = ItemsDistributions.pickRandomUnit(this.getRandomNumberStream(ItemGeneratorColumn.I_UNITS));
        String iContainer = "Unknown";
        String iProductName = RandomValueGenerator.generateWord(rowNumber, 50, EnglishDistributions.SYLLABLES_DISTRIBUTION);
        long iPromoSk = JoinKeyUtils.generateJoinKey(ItemGeneratorColumn.I_PROMO_SK, this.getRandomNumberStream(ItemGeneratorColumn.I_PROMO_SK), Table.PROMOTION, 1L, session.getScaling());
        int temp = RandomValueGenerator.generateUniformRandomInt(1, 100, this.getRandomNumberStream(ItemGeneratorColumn.I_PROMO_SK));
        if (temp > 20) {
            iPromoSk = -1L;
        }
        ItemRow row = new ItemRow(nullBitMap, iItemSk, iItemId, iRecStartDateId, iRecEndDateId, iItemDesc, iCurrentPrice, iWholesaleCost, iBrandId, iBrand, iClassId, iClass, iCategoryId, iCategory, iManufactId, iManufact, iSize, iFormulation, iColor, iUnits, iContainer, iManagerId, iProductName, iPromoSk);
        this.previousRow = Optional.of(row);
        return new RowGeneratorResult(row);
    }
}

