/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.BusinessKeyGenerator;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.ReturnReasonsDistribution;
import io.trino.tpcds.generator.ReasonGeneratorColumn;
import io.trino.tpcds.row.ReasonRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;

public class ReasonRowGenerator
extends AbstractRowGenerator {
    public ReasonRowGenerator() {
        super(Table.REASON);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.REASON, this.getRandomNumberStream(ReasonGeneratorColumn.R_NULLS));
        long rReasonSk = rowNumber;
        String rReasonId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        String rReasonDescription = ReturnReasonsDistribution.getReturnReasonAtIndex((int)(rowNumber - 1L));
        return new RowGeneratorResult(new ReasonRow(nullBitMap, rReasonSk, rReasonId, rReasonDescription));
    }
}

