/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.SlowlyChangingDimensionUtils;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.CallCenterDistributions;
import io.trino.tpcds.distribution.EnglishDistributions;
import io.trino.tpcds.distribution.NamesDistributions;
import io.trino.tpcds.generator.StoreGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.StoreRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Address;
import io.trino.tpcds.type.Date;
import io.trino.tpcds.type.Decimal;
import java.util.Optional;

public class StoreRowGenerator
extends AbstractRowGenerator {
    private static final int ROW_SIZE_S_MARKET_DESC = 100;
    private static final Decimal STORE_MIN_TAX_PERCENTAGE = new Decimal(0L, 2);
    private static final Decimal STORE_MAX_TAX_PERCENTAGE = new Decimal(11L, 2);
    private static final int STORE_MIN_DAYS_OPEN = 5;
    private static final int STORE_MAX_DAYS_OPEN = 500;
    private static final int STORE_CLOSED_PCT = 30;
    private static final int STORE_DESC_MIN = 15;
    private Optional<StoreRow> previousRow = Optional.empty();

    public StoreRowGenerator() {
        super(Table.STORE);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.STORE, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_NULLS));
        long storeSk = rowNumber;
        SlowlyChangingDimensionUtils.SlowlyChangingDimensionKey slowlyChangingDimensionKey = SlowlyChangingDimensionUtils.computeScdKey(Table.S_STORE, rowNumber);
        String storeId = slowlyChangingDimensionKey.getBusinessKey();
        long recStartDateId = slowlyChangingDimensionKey.getStartDate();
        long recEndDateId = slowlyChangingDimensionKey.getEndDate();
        boolean isNewBusinessKey = slowlyChangingDimensionKey.isNewBusinessKey();
        int fieldChangeFlags = (int)this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_SCD).nextRandom();
        int percentage = RandomValueGenerator.generateUniformRandomInt(1, 100, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_CLOSED_DATE_ID));
        int daysOpen = RandomValueGenerator.generateUniformRandomInt(5, 500, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_CLOSED_DATE_ID));
        long closedDateId = percentage < 30 ? (long)(Date.JULIAN_DATE_MINIMUM + daysOpen) : -1L;
        if (this.previousRow.isPresent()) {
            closedDateId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getClosedDateId(), closedDateId);
        }
        fieldChangeFlags >>= 1;
        String storeName = RandomValueGenerator.generateWord(rowNumber, 5, EnglishDistributions.SYLLABLES_DISTRIBUTION);
        if (this.previousRow.isPresent()) {
            storeName = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getStoreName(), storeName);
        }
        fieldChangeFlags >>= 1;
        int employees = RandomValueGenerator.generateUniformRandomInt(200, 300, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_EMPLOYEES));
        if (this.previousRow.isPresent()) {
            employees = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getEmployees(), employees);
        }
        fieldChangeFlags >>= 1;
        int floorSpace = RandomValueGenerator.generateUniformRandomInt(5000000, 10000000, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_FLOOR_SPACE));
        if (this.previousRow.isPresent()) {
            floorSpace = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getFloorSpace(), floorSpace);
        }
        fieldChangeFlags >>= 1;
        String hours = CallCenterDistributions.pickRandomCallCenterHours(this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_HOURS));
        fieldChangeFlags >>= 1;
        String firstName = NamesDistributions.pickRandomFirstName(session.isSexist() ? NamesDistributions.FirstNamesWeights.MALE_FREQUENCY : NamesDistributions.FirstNamesWeights.GENERAL_FREQUENCY, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_MANAGER));
        String lastName = NamesDistributions.pickRandomLastName(this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_MANAGER));
        String storeManager = String.format("%s %s", firstName, lastName);
        if (this.previousRow.isPresent()) {
            storeManager = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getStoreManager(), storeManager);
        }
        fieldChangeFlags >>= 1;
        int marketId = RandomValueGenerator.generateUniformRandomInt(1, 10, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_MARKET_ID));
        if (this.previousRow.isPresent()) {
            marketId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getMarketId(), marketId);
        }
        fieldChangeFlags >>= 1;
        Decimal dTaxPercentage = RandomValueGenerator.generateUniformRandomDecimal(STORE_MIN_TAX_PERCENTAGE, STORE_MAX_TAX_PERCENTAGE, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_TAX_PERCENTAGE));
        if (this.previousRow.isPresent()) {
            dTaxPercentage = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getdTaxPercentage(), dTaxPercentage);
        }
        fieldChangeFlags >>= 1;
        String geographyClass = "Unknown";
        fieldChangeFlags >>= 1;
        String marketDesc = RandomValueGenerator.generateRandomText(15, 100, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_MARKET_DESC));
        if (this.previousRow.isPresent()) {
            marketDesc = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getMarketDesc(), marketDesc);
        }
        fieldChangeFlags >>= 1;
        firstName = NamesDistributions.pickRandomFirstName(session.isSexist() ? NamesDistributions.FirstNamesWeights.MALE_FREQUENCY : NamesDistributions.FirstNamesWeights.GENERAL_FREQUENCY, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_MARKET_MANAGER));
        lastName = NamesDistributions.pickRandomLastName(this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_MARKET_MANAGER));
        String marketManager = String.format("%s %s", firstName, lastName);
        if (this.previousRow.isPresent()) {
            marketManager = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getMarketManager(), marketManager);
        }
        fieldChangeFlags >>= 1;
        String divisionName = "Unknown";
        int divisionId = 1;
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        String companyName = "Unknown";
        int companyId = 1;
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        Address address = Address.makeAddressForColumn(Table.STORE, this.getRandomNumberStream(StoreGeneratorColumn.W_STORE_ADDRESS), session.getScaling());
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        int gmtOffset = address.getGmtOffset();
        if (this.previousRow.isPresent()) {
            gmtOffset = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getAddress().getGmtOffset(), gmtOffset);
        }
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        int streetNumber = address.getStreetNumber();
        if (this.previousRow.isPresent()) {
            streetNumber = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getAddress().getStreetNumber(), streetNumber);
        }
        fieldChangeFlags >>= 1;
        int zip = address.getZip();
        if (this.previousRow.isPresent()) {
            zip = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getAddress().getZip(), zip);
        }
        address = new Address(address.getSuiteNumber(), streetNumber, address.getStreetName1(), address.getStreetName2(), address.getStreetType(), address.getCity(), address.getCounty(), address.getState(), address.getCountry(), zip, gmtOffset);
        StoreRow row = new StoreRow(nullBitMap, storeSk, storeId, recStartDateId, recEndDateId, closedDateId, storeName, employees, floorSpace, hours, storeManager, marketId, dTaxPercentage, geographyClass, marketDesc, marketManager, divisionId, divisionName, companyId, companyName, address);
        this.previousRow = Optional.of(row);
        return new RowGeneratorResult(row);
    }
}

