/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.SortingColumn;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitioningHandle;
import io.trino.plugin.hive.util.HiveBucketing;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public record HiveTablePartitioning(boolean active, List<HiveColumnHandle> columns, HivePartitioningHandle partitioningHandle, int tableBucketCount, List<SortingColumn> sortedBy, boolean forWrite) {
    public HiveTablePartitioning {
        columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        columns.forEach(column -> Preconditions.checkArgument((boolean)column.isBaseColumn(), (Object)String.format("projected column %s is not allowed for bucketing", column)));
        Preconditions.checkArgument((boolean)columns.stream().map(HiveColumnHandle::getHiveType).toList().equals(partitioningHandle.getHiveTypes()), (Object)"columns do not match partitioning handle");
        Preconditions.checkArgument((tableBucketCount > 0 ? 1 : 0) != 0, (Object)"tableBucketCount must be greater than zero");
        Preconditions.checkArgument((tableBucketCount >= partitioningHandle.getBucketCount() ? 1 : 0) != 0, (Object)"tableBucketCount must be greater than or equal to partitioningHandle.bucketCount");
        sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
        Preconditions.checkArgument((!forWrite || active ? 1 : 0) != 0, (Object)"Partitioning must be active for write");
        Preconditions.checkArgument((forWrite || !partitioningHandle.isUsePartitionedBucketing() ? 1 : 0) != 0, (Object)"Partitioned bucketing is only supported for write");
    }

    public HiveTablePartitioning(boolean active, HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, List<HiveColumnHandle> columns, boolean usePartitionedBucketing, List<SortingColumn> sortedBy, boolean forWrite) {
        this(active, columns, new HivePartitioningHandle(bucketingVersion, bucketCount, (List)columns.stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), usePartitionedBucketing), bucketCount, sortedBy, forWrite);
    }

    public HiveTablePartitioning withActivePartitioning() {
        return new HiveTablePartitioning(true, this.columns, this.partitioningHandle, this.tableBucketCount, this.sortedBy, this.forWrite);
    }

    public HiveTablePartitioning withPartitioningHandle(HivePartitioningHandle hivePartitioningHandle) {
        return new HiveTablePartitioning(this.active, this.columns, hivePartitioningHandle, this.tableBucketCount, this.sortedBy, this.forWrite);
    }

    public HiveBucketProperty toTableBucketProperty() {
        return new HiveBucketProperty(this.columns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList()), this.tableBucketCount, this.sortedBy);
    }
}

