/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.VarcharType;

public final class DoubleToVarcharCoercers {
    private DoubleToVarcharCoercers() {
    }

    public static TypeCoercer<DoubleType, VarcharType> createDoubleToVarcharCoercer(VarcharType toType, boolean isOrcFile) {
        return isOrcFile ? new OrcDoubleToVarcharCoercer(toType) : new DoubleToVarcharCoercer(toType);
    }

    private static void writeDoubleAsSlice(double value, BlockBuilder blockBuilder, VarcharType varcharType) {
        Slice converted = Slices.utf8Slice((String)Double.toString(value));
        if (!varcharType.isUnbounded() && SliceUtf8.countCodePoints((Slice)converted) > varcharType.getBoundedLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Varchar representation of %s exceeds %s bounds", value, varcharType));
        }
        varcharType.writeSlice(blockBuilder, converted);
    }

    public static class OrcDoubleToVarcharCoercer
    extends TypeCoercer<DoubleType, VarcharType> {
        public OrcDoubleToVarcharCoercer(VarcharType toType) {
            super(DoubleType.DOUBLE, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            double doubleValue = DoubleType.DOUBLE.getDouble(block, position);
            if (Double.isNaN(doubleValue)) {
                blockBuilder.appendNull();
                return;
            }
            DoubleToVarcharCoercers.writeDoubleAsSlice(doubleValue, blockBuilder, (VarcharType)this.toType);
        }
    }

    public static class DoubleToVarcharCoercer
    extends TypeCoercer<DoubleType, VarcharType> {
        public DoubleToVarcharCoercer(VarcharType toType) {
            super(DoubleType.DOUBLE, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            DoubleToVarcharCoercers.writeDoubleAsSlice(DoubleType.DOUBLE.getDouble(block, position), blockBuilder, (VarcharType)this.toType);
        }
    }
}

