/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.AllowHiveTableRename;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.CachingHiveMetastoreModule;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.MetastoreTypeConfig;
import io.trino.plugin.hive.metastore.file.FileMetastoreModule;
import io.trino.plugin.hive.metastore.glue.v1.GlueMetastoreModule;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreModule;
import java.util.Optional;

public class HiveMetastoreModule
extends AbstractConfigurationAwareModule {
    private final Optional<HiveMetastore> metastore;

    public HiveMetastoreModule(Optional<HiveMetastore> metastore) {
        this.metastore = metastore;
    }

    protected void setup(Binder binder) {
        if (this.metastore.isPresent()) {
            binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).toInstance((Object)HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastore.get()));
            binder.bind(Key.get(Boolean.TYPE, AllowHiveTableRename.class)).toInstance((Object)true);
        } else {
            this.bindMetastoreModule("thrift", (Module)new ThriftMetastoreModule());
            this.bindMetastoreModule("file", new FileMetastoreModule());
            this.bindMetastoreModule("glue", (Module)new io.trino.plugin.hive.metastore.glue.GlueMetastoreModule());
            this.bindMetastoreModule("glue-v1", (Module)new GlueMetastoreModule());
        }
        this.install((Module)new CachingHiveMetastoreModule());
    }

    private void bindMetastoreModule(String name, Module module) {
        this.install(ConditionalModule.conditionalModule(MetastoreTypeConfig.class, metastore -> name.equalsIgnoreCase(metastore.getMetastoreType()), (Module)module));
    }

    @HideDeltaLakeTables
    @Singleton
    @Provides
    public boolean hideDeltaLakeTables(HiveMetastoreConfig hiveMetastoreConfig) {
        return hiveMetastoreConfig.isHideDeltaLakeTables();
    }
}

