/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.inject.Inject;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;

public class GlueHiveExecutionInterceptor
implements ExecutionInterceptor {
    private final boolean skipArchive;

    @Inject
    GlueHiveExecutionInterceptor(GlueHiveMetastoreConfig config) {
        this.skipArchive = config.isSkipArchive();
    }

    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest sdkRequest = context.request();
        if (sdkRequest instanceof UpdateTableRequest) {
            UpdateTableRequest updateTableRequest = (UpdateTableRequest)sdkRequest;
            return (SdkRequest)updateTableRequest.toBuilder().skipArchive(Boolean.valueOf(this.skipArchive)).build();
        }
        return context.request();
    }
}

