/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import io.trino.plugin.hive.metastore.glue.AwsApiCallStats;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class AwsSdkUtil {
    private AwsSdkUtil() {
    }

    public static <Request, Result> Stream<Result> getPaginatedResults(final Function<Request, Result> submission, final Request request, final BiConsumer<Request, String> setNextToken, final Function<Result, String> extractNextToken, final AwsApiCallStats stats) {
        Objects.requireNonNull(submission, "submission is null");
        Objects.requireNonNull(request, "request is null");
        Objects.requireNonNull(setNextToken, "setNextToken is null");
        Objects.requireNonNull(extractNextToken, "extractNextToken is null");
        AbstractIterator iterator = new AbstractIterator<Result>(){
            private String nextToken;
            private boolean firstRequest = true;

            protected Result computeNext() {
                if (this.nextToken == null && !this.firstRequest) {
                    return this.endOfData();
                }
                setNextToken.accept(request, this.nextToken);
                Object result = stats.call(() -> submission.apply(request));
                this.firstRequest = false;
                this.nextToken = (String)extractNextToken.apply(result);
                return result;
            }
        };
        return Streams.stream((Iterator)iterator);
    }
}

