/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.retry.PredefinedBackoffStrategies;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.AWSGlueAsyncClientBuilder;
import com.amazonaws.services.glue.model.ConcurrentModificationException;
import com.google.common.base.Preconditions;
import io.trino.plugin.hive.metastore.glue.v1.AwsCurrentRegionHolder;
import io.trino.plugin.hive.metastore.glue.v1.GlueHiveMetastoreConfig;
import java.util.Set;

public final class GlueClientUtil {
    private GlueClientUtil() {
    }

    public static AWSGlueAsync createAsyncGlueClient(GlueHiveMetastoreConfig config, AWSCredentialsProvider credentialsProvider, Set<RequestHandler2> requestHandlers, RequestMetricCollector metricsCollector) {
        RetryPolicy defaultRetryPolicy = PredefinedRetryPolicies.getDefaultRetryPolicy();
        RetryPolicy.RetryCondition customRetryCondition = (requestContext, exception, retriesAttempted) -> defaultRetryPolicy.getRetryCondition().shouldRetry(requestContext, exception, retriesAttempted) || exception instanceof ConcurrentModificationException;
        PredefinedBackoffStrategies.ExponentialBackoffStrategy customBackoffStrategy = new PredefinedBackoffStrategies.ExponentialBackoffStrategy(20, 1500);
        RetryPolicy glueRetryPolicy = RetryPolicy.builder().withRetryMode(defaultRetryPolicy.getRetryMode()).withRetryCondition(customRetryCondition).withBackoffStrategy((RetryPolicy.BackoffStrategy)customBackoffStrategy).withFastFailRateLimiting(defaultRetryPolicy.isFastFailRateLimiting()).withMaxErrorRetry(config.getMaxGlueErrorRetries()).build();
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(config.getMaxGlueConnections()).withRetryPolicy(glueRetryPolicy);
        AWSGlueAsyncClientBuilder asyncGlueClientBuilder = (AWSGlueAsyncClientBuilder)((AWSGlueAsyncClientBuilder)AWSGlueAsyncClientBuilder.standard().withMetricsCollector(metricsCollector)).withClientConfiguration(clientConfig);
        asyncGlueClientBuilder.setRequestHandlers((RequestHandler2[])requestHandlers.toArray(RequestHandler2[]::new));
        if (config.getGlueEndpointUrl().isPresent()) {
            Preconditions.checkArgument((boolean)config.getGlueRegion().isPresent(), (Object)"Glue region must be set when Glue endpoint URL is set");
            asyncGlueClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.getGlueEndpointUrl().get(), config.getGlueRegion().get()));
        } else if (config.getGlueRegion().isPresent()) {
            asyncGlueClientBuilder.setRegion(config.getGlueRegion().get());
        } else if (config.getPinGlueClientToCurrentRegion()) {
            asyncGlueClientBuilder.setRegion(AwsCurrentRegionHolder.getCurrentRegionFromEc2Metadata().getName());
        }
        asyncGlueClientBuilder.setCredentials(credentialsProvider);
        return (AWSGlueAsync)asyncGlueClientBuilder.build();
    }
}

