/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.authentication.CachingKerberosAuthentication;
import io.trino.plugin.base.authentication.KerberosAuthentication;
import io.trino.plugin.base.authentication.KerberosConfiguration;
import io.trino.plugin.hive.metastore.thrift.ForHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.KerberosHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.MetastoreKerberosConfig;
import io.trino.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreAuthenticationConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.trino.plugin.hive.metastore.thrift.TokenFetchingMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.UgiBasedMetastoreClientFactory;
import org.weakref.jmx.guice.ExportBinder;

public class ThriftMetastoreAuthenticationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        OptionalBinder.newOptionalBinder((Binder)binder, IdentityAwareMetastoreClientFactory.class).setDefault().to(UgiBasedMetastoreClientFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IdentityAwareMetastoreClientFactory.class).as(generator -> generator.generatedNameOf(ThriftMetastoreStats.class));
        OptionalBinder.newOptionalBinder((Binder)binder, HiveMetastoreAuthentication.class).setDefault().to(NoHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
        if (((ThriftMetastoreAuthenticationConfig)this.buildConfigObject(ThriftMetastoreAuthenticationConfig.class)).getAuthenticationType() == ThriftMetastoreAuthenticationConfig.ThriftMetastoreAuthenticationType.KERBEROS) {
            this.install(new KerberosHiveMetastoreAuthenticationModule());
        }
    }

    public static class KerberosHiveMetastoreAuthenticationModule
    implements Module {
        public void configure(Binder binder) {
            OptionalBinder.newOptionalBinder((Binder)binder, IdentityAwareMetastoreClientFactory.class).setBinding().to(TokenFetchingMetastoreClientFactory.class).in(Scopes.SINGLETON);
            OptionalBinder.newOptionalBinder((Binder)binder, HiveMetastoreAuthentication.class).setBinding().to(KerberosHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
            ConfigBinder.configBinder((Binder)binder).bindConfig(MetastoreKerberosConfig.class);
        }

        @Provides
        @Singleton
        @ForHiveMetastore
        public CachingKerberosAuthentication createKerberosAuthentication(MetastoreKerberosConfig config) {
            String principal = config.getHiveMetastoreClientPrincipal();
            KerberosConfiguration.Builder builder = new KerberosConfiguration.Builder().withKerberosPrincipal(principal);
            config.getHiveMetastoreClientKeytab().ifPresent(arg_0 -> ((KerberosConfiguration.Builder)builder).withKeytabLocation(arg_0));
            config.getHiveMetastoreClientCredentialCacheLocation().ifPresent(arg_0 -> ((KerberosConfiguration.Builder)builder).withCredentialCacheLocation(arg_0));
            return new CachingKerberosAuthentication(new KerberosAuthentication(builder.build()));
        }
    }
}

