/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.hive.thrift.metastore.GetOpenTxnsResponse;
import io.trino.hive.thrift.metastore.TableValidWriteIds;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public final class TxnUtils {
    private TxnUtils() {
    }

    public static String createValidReadTxnList(GetOpenTxnsResponse txns, long currentTxn) {
        List openTxns = txns.getOpenTxns();
        int sizeToHwm = currentTxn > 0L ? Collections.binarySearch(openTxns, currentTxn) : openTxns.size();
        long[] exceptions = new long[Math.abs(sizeToHwm)];
        BitSet inAbortedBits = BitSet.valueOf(txns.getAbortedBits());
        BitSet outAbortedBits = new BitSet();
        long minOpenTxnId = Long.MAX_VALUE;
        int i = 0;
        Iterator iterator = openTxns.iterator();
        while (iterator.hasNext()) {
            long txn = (Long)iterator.next();
            if (currentTxn > 0L && txn >= currentTxn) break;
            if (inAbortedBits.get(i)) {
                outAbortedBits.set(i);
            } else if (minOpenTxnId == Long.MAX_VALUE) {
                minOpenTxnId = txn;
            }
            exceptions[i] = txn;
            ++i;
        }
        long highWaterMark = currentTxn > 0L ? Math.min(currentTxn, txns.getTxnHighWaterMark()) : txns.getTxnHighWaterMark();
        StringBuilder builder = new StringBuilder().append(highWaterMark).append(':').append(exceptions.length > 0 ? minOpenTxnId : Long.MAX_VALUE);
        TxnUtils.appendTransactions(builder, exceptions, outAbortedBits);
        return builder.toString();
    }

    public static String createValidTxnWriteIdList(long currentTxnId, List<TableValidWriteIds> validIds) {
        HashMap<String, String> lists = new HashMap<String, String>();
        for (TableValidWriteIds ids : validIds) {
            lists.put(ids.getFullTableName(), TxnUtils.createValidWriteIdList(ids));
        }
        StringJoiner joiner = new StringJoiner("$").add(String.valueOf(currentTxnId));
        lists.values().forEach(joiner::add);
        return joiner.toString();
    }

    public static String createValidWriteIdList(TableValidWriteIds writeIds) {
        List invalids = writeIds.getInvalidWriteIds();
        BitSet abortedBits = BitSet.valueOf(writeIds.getAbortedBits());
        long[] exceptions = new long[invalids.size()];
        int i = 0;
        Iterator iterator = invalids.iterator();
        while (iterator.hasNext()) {
            long writeId;
            exceptions[i] = writeId = ((Long)iterator.next()).longValue();
            ++i;
        }
        long minOpenWriteId = writeIds.isSetMinOpenWriteId() ? writeIds.getMinOpenWriteId() : Long.MAX_VALUE;
        StringBuilder builder = new StringBuilder().append(Objects.requireNonNullElse(writeIds.getFullTableName(), "null")).append(':').append(writeIds.getWriteIdHighWaterMark()).append(':').append(exceptions.length > 0 ? minOpenWriteId : Long.MAX_VALUE);
        TxnUtils.appendTransactions(builder, exceptions, abortedBits);
        return builder.toString();
    }

    private static void appendTransactions(StringBuilder builder, long[] exceptions, BitSet abortedBits) {
        StringBuilder open = new StringBuilder();
        StringBuilder abort = new StringBuilder();
        for (int i = 0; i < exceptions.length; ++i) {
            if (abortedBits.get(i)) {
                if (!abort.isEmpty()) {
                    abort.append(',');
                }
                abort.append(exceptions[i]);
                continue;
            }
            if (!open.isEmpty()) {
                open.append(',');
            }
            open.append(exceptions[i]);
        }
        builder.append(':').append((CharSequence)open);
        builder.append(':').append((CharSequence)abort);
    }
}

