/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;

@DefunctConfig(value={"hive.parquet.optimized-writer.enabled", "parquet.experimental-optimized-writer.enabled", "parquet.optimized-writer.enabled"})
public class ParquetWriterConfig {
    public static final String PARQUET_WRITER_MAX_BLOCK_SIZE = "2GB";
    public static final String PARQUET_WRITER_MIN_PAGE_SIZE = "8kB";
    public static final String PARQUET_WRITER_MAX_PAGE_SIZE = "8MB";
    public static final int PARQUET_WRITER_MIN_PAGE_VALUE_COUNT = 1000;
    public static final int PARQUET_WRITER_MAX_PAGE_VALUE_COUNT = 200000;
    private DataSize blockSize = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize pageSize = DataSize.ofBytes((long)0x100000L);
    private int pageValueCount = 60000;
    private int batchSize = 10000;
    private double validationPercentage = 5.0;

    @MaxDataSize(value="2GB")
    public @MaxDataSize(value="2GB") DataSize getBlockSize() {
        return this.blockSize;
    }

    @Config(value="parquet.writer.block-size")
    @LegacyConfig(value={"hive.parquet.writer.block-size"})
    public ParquetWriterConfig setBlockSize(DataSize blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    @MinDataSize(value="8kB")
    @MaxDataSize(value="8MB")
    public @MinDataSize(value="8kB") @MaxDataSize(value="8MB") DataSize getPageSize() {
        return this.pageSize;
    }

    @Config(value="parquet.writer.page-size")
    @LegacyConfig(value={"hive.parquet.writer.page-size"})
    public ParquetWriterConfig setPageSize(DataSize pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Min(value=1000L)
    @Max(value=200000L)
    public @Min(value=1000L) @Max(value=200000L) int getPageValueCount() {
        return this.pageValueCount;
    }

    @Config(value="parquet.writer.page-value-count")
    public ParquetWriterConfig setPageValueCount(int pageValueCount) {
        this.pageValueCount = pageValueCount;
        return this;
    }

    @Config(value="parquet.writer.batch-size")
    @ConfigDescription(value="Maximum number of rows passed to the writer in each batch")
    public ParquetWriterConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="100.0") double getValidationPercentage() {
        return this.validationPercentage;
    }

    @Config(value="parquet.writer.validation-percentage")
    @LegacyConfig(value={"parquet.optimized-writer.validation-percentage"})
    @ConfigDescription(value="Percentage of parquet files to validate after write by re-reading the whole file")
    public ParquetWriterConfig setValidationPercentage(double validationPercentage) {
        this.validationPercentage = validationPercentage;
        return this;
    }
}

