/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.metastore.Column;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.Partition;
import io.trino.metastore.Partitions;
import io.trino.metastore.Table;
import io.trino.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.TableInvalidationCallback;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.metastore.glue.PartitionName;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class FlushMetadataCacheProcedure
implements Provider<Procedure> {
    private static final String PROCEDURE_NAME = "flush_metadata_cache";
    private static final String PARAM_SCHEMA_NAME = "SCHEMA_NAME";
    private static final String PARAM_TABLE_NAME = "TABLE_NAME";
    private static final String PARAM_PARTITION_COLUMNS = "PARTITION_COLUMNS";
    private static final String PARAM_PARTITION_VALUES = "PARTITION_VALUES";
    private static final String PROCEDURE_USAGE_EXAMPLES = String.format("Valid usages:%n - '%1$s()'%n - %1$s(%2$s => ..., %3$s => ...) - %1$s(%2$s => ..., %3$s => ..., %4$s => ARRAY['...'], %5$s => ARRAY['...'])", "flush_metadata_cache", "SCHEMA_NAME".toLowerCase(Locale.ENGLISH), "TABLE_NAME".toLowerCase(Locale.ENGLISH), "PARTITION_COLUMNS".toLowerCase(Locale.ENGLISH), "PARTITION_VALUES".toLowerCase(Locale.ENGLISH));
    private static final MethodHandle FLUSH_HIVE_METASTORE_CACHE;
    private final HiveMetastoreFactory hiveMetadataFactory;
    private final Optional<DirectoryLister> directoryLister;
    private final Optional<CachingHiveMetastore> cachingHiveMetastore;
    private final Optional<GlueCache> glueCache;

    @Inject
    public FlushMetadataCacheProcedure(HiveMetastoreFactory hiveMetadataFactory, Optional<DirectoryLister> directoryLister, Optional<CachingHiveMetastore> cachingHiveMetastore, Optional<GlueCache> glueCache) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.cachingHiveMetastore = Objects.requireNonNull(cachingHiveMetastore, "cachingHiveMetastore is null");
        this.glueCache = Objects.requireNonNull(glueCache, "glueCache is null");
    }

    public Procedure get() {
        return new Procedure("system", PROCEDURE_NAME, (List)ImmutableList.of((Object)new Procedure.Argument(PARAM_SCHEMA_NAME, (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument(PARAM_TABLE_NAME, (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument(PARAM_PARTITION_COLUMNS, (Type)new ArrayType((Type)VarcharType.VARCHAR), false, null), (Object)new Procedure.Argument(PARAM_PARTITION_VALUES, (Type)new ArrayType((Type)VarcharType.VARCHAR), false, null)), FLUSH_HIVE_METASTORE_CACHE.bindTo(this), true);
    }

    public void flushMetadataCache(ConnectorSession session, String schemaName, String tableName, List<String> partitionColumns, List<String> partitionValues) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doFlushMetadataCache(session, Optional.ofNullable(schemaName), Optional.ofNullable(tableName), Optional.ofNullable(partitionColumns).orElse((List<String>)ImmutableList.of()), Optional.ofNullable(partitionValues).orElse((List<String>)ImmutableList.of()));
        }
    }

    private void doFlushMetadataCache(ConnectorSession session, Optional<String> schemaName, Optional<String> tableName, List<String> partitionColumns, List<String> partitionValues) {
        if (this.cachingHiveMetastore.isEmpty() && this.glueCache.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Cannot flush, metastore cache is not enabled");
        }
        Preconditions.checkState((partitionColumns.size() == partitionValues.size() ? 1 : 0) != 0, (Object)"Parameters partition_column and partition_value should have same length");
        if (schemaName.isEmpty() && tableName.isEmpty() && partitionColumns.isEmpty()) {
            this.cachingHiveMetastore.ifPresent(CachingHiveMetastore::flushCache);
            this.glueCache.ifPresent(GlueCache::flushCache);
            this.directoryLister.ifPresent(TableInvalidationCallback::invalidateAll);
        } else if (schemaName.isPresent() && tableName.isPresent()) {
            Object partitions;
            HiveMetastore metastore = this.hiveMetadataFactory.createMetastore(Optional.of(session.getIdentity()));
            Table table = (Table)metastore.getTable(schemaName.get(), tableName.get()).orElseThrow(() -> new TableNotFoundException(new SchemaTableName((String)schemaName.get(), (String)tableName.get())));
            if (!partitionColumns.isEmpty()) {
                this.cachingHiveMetastore.ifPresent(cachingHiveMetastore -> cachingHiveMetastore.flushPartitionCache((String)schemaName.get(), (String)tableName.get(), partitionColumns, partitionValues));
                this.glueCache.ifPresent(glueCache -> glueCache.invalidatePartition((String)schemaName.get(), (String)tableName.get(), new PartitionName(partitionValues)));
                partitions = ImmutableList.of((Object)Partitions.makePartName(partitionColumns, partitionValues));
            } else {
                this.cachingHiveMetastore.ifPresent(cachingHiveMetastore -> cachingHiveMetastore.invalidateTable((String)schemaName.get(), (String)tableName.get()));
                this.glueCache.ifPresent(glueCache -> glueCache.invalidateTable((String)schemaName.get(), (String)tableName.get(), true));
                List partitionColumnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
                partitions = (List)metastore.getPartitionNamesByFilter(schemaName.get(), tableName.get(), partitionColumnNames, TupleDomain.all()).orElse(ImmutableList.of());
            }
            if (this.directoryLister.isPresent()) {
                if (partitions.isEmpty()) {
                    this.directoryLister.get().invalidate(table);
                } else {
                    metastore.getPartitionsByNames(table, (List)partitions).values().stream().filter(Optional::isPresent).map(Optional::get).forEach(partition -> this.directoryLister.get().invalidate((Partition)partition));
                }
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Illegal parameter set passed. " + PROCEDURE_USAGE_EXAMPLES);
        }
    }

    static {
        try {
            FLUSH_HIVE_METASTORE_CACHE = MethodHandles.lookup().unreflect(FlushMetadataCacheProcedure.class.getMethod("flushMetadataCache", ConnectorSession.class, String.class, String.class, List.class, List.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

