/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.rcfile;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.rcfile.RcFileReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class RcFilePageSource
implements ConnectorPageSource {
    private static final long GUESSED_MEMORY_USAGE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    private final RcFileReader rcFileReader;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int pageId;
    private boolean closed;

    public RcFilePageSource(RcFileReader rcFileReader, List<HiveColumnHandle> columns) {
        Objects.requireNonNull(rcFileReader, "rcFileReader is null");
        Objects.requireNonNull(columns, "columns is null");
        this.rcFileReader = rcFileReader;
        int size = columns.size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            namesBuilder.add((Object)column.getName());
            typesBuilder.add((Object)column.getType());
            this.hiveColumnIndexes[columnIndex] = column.getBaseHiveColumnIndex();
            if (this.hiveColumnIndexes[columnIndex] < rcFileReader.getColumnCount()) continue;
            this.constantBlocks[columnIndex] = column.getType().createNullBlock();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
    }

    public long getCompletedBytes() {
        return this.rcFileReader.getBytesRead();
    }

    public long getReadTimeNanos() {
        return this.rcFileReader.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.pageId;
            int currentPageSize = this.rcFileReader.advance();
            if (currentPageSize < 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                blocks[fieldId] = this.constantBlocks[fieldId] != null ? RunLengthEncodedBlock.create((Block)this.constantBlocks[fieldId], (int)currentPageSize) : this.createBlock(currentPageSize, fieldId);
            }
            return new Page(currentPageSize, blocks);
        }
        catch (TrinoException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw e;
        }
        catch (FileCorruptionException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted RC file: %s", this.rcFileReader.getFileLocation()), (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read RC file: %s", this.rcFileReader.getFileLocation()), (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rcFileReader.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    public long getMemoryUsage() {
        return GUESSED_MEMORY_USAGE;
    }

    private Block createBlock(int currentPageSize, int fieldId) {
        int hiveColumnIndex = this.hiveColumnIndexes[fieldId];
        return new LazyBlock(currentPageSize, (LazyBlockLoader)new RcFileBlockLoader(hiveColumnIndex));
    }

    private final class RcFileBlockLoader
    implements LazyBlockLoader {
        private final int expectedBatchId;
        private final int columnIndex;
        private boolean loaded;

        public RcFileBlockLoader(int columnIndex) {
            this.expectedBatchId = RcFilePageSource.this.pageId;
            this.columnIndex = columnIndex;
        }

        public Block load() {
            Block block;
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Preconditions.checkState((RcFilePageSource.this.pageId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                block = RcFilePageSource.this.rcFileReader.readBlock(this.columnIndex);
            }
            catch (FileCorruptionException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted RC file: %s", RcFilePageSource.this.rcFileReader.getFileLocation()), (Throwable)e);
            }
            catch (IOException | RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read RC file: %s", RcFilePageSource.this.rcFileReader.getFileLocation()), (Throwable)e);
            }
            this.loaded = true;
            return block;
        }
    }
}

