/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mariadb;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgDecimal;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementStddevPop;
import io.trino.plugin.jdbc.aggregation.ImplementStddevSamp;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.aggregation.ImplementVariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementVarianceSamp;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.mariadb.ImplementAvgBigint;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnPosition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.lang.runtime.SwitchBootstraps;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;

public class MariaDbClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(MariaDbClient.class);
    private static final int MAX_SUPPORTED_DATE_TIME_PRECISION = 6;
    private static final int ZERO_PRECISION_TIME_COLUMN_SIZE = 10;
    private static final int ZERO_PRECISION_TIMESTAMP_COLUMN_SIZE = 19;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final String NO_COMMENT = "";
    private static final int PARSE_ERROR = 1064;
    private final boolean statisticsEnabled;
    private final ConnectorExpressionRewriter<ParameterizedExpression> connectorExpressionRewriter;
    private final AggregateFunctionRewriter<JdbcExpression, ?> aggregateFunctionRewriter;

    @Inject
    public MariaDbClient(BaseJdbcConfig config, JdbcStatisticsConfig statisticsConfig, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        super("`", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, true);
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((MariaDbClient)this).quoted(arg_0)).withTypeClass("numeric_type", (Set)ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"integer", (Object)"bigint", (Object)"decimal", (Object)"double", (Object[])new String[0])).map("$equal(left: numeric_type, right: numeric_type)").to("left = right").map("$not_equal(left: numeric_type, right: numeric_type)").to("left <> right").map("$less_than(left: numeric_type, right: numeric_type)").to("left < right").map("$less_than_or_equal(left: numeric_type, right: numeric_type)").to("left <= right").map("$greater_than(left: numeric_type, right: numeric_type)").to("left > right").map("$greater_than_or_equal(left: numeric_type, right: numeric_type)").to("left >= right").build();
        this.statisticsEnabled = statisticsConfig.isEnabled();
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax(false)).add((Object)new ImplementSum(MariaDbClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementStddevSamp()).add((Object)new ImplementStddevPop()).add((Object)new ImplementVarianceSamp()).add((Object)new ImplementVariancePop()).build());
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return MariaDbClient.preventTextualTypeAggregationPushdown(groupingSets);
    }

    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.connectorExpressionRewriter.rewrite(session, expression, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    public Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getCatalogs();
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_CAT");
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    protected boolean filterSchema(String schemaName) {
        if (schemaName.equalsIgnoreCase("mysql") || schemaName.equalsIgnoreCase("performance_schema")) {
            return false;
        }
        return super.filterSchema(schemaName);
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    protected void dropSchema(ConnectorSession session, Connection connection, String remoteSchemaName, boolean cascade) throws SQLException {
        if (!cascade) {
            try (ResultSet tables = this.getTables(connection, Optional.of(remoteSchemaName), Optional.empty());){
                if (tables.next()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Cannot drop non-empty schema '%s'".formatted(remoteSchemaName));
                }
            }
        }
        this.execute(session, connection, "DROP SCHEMA " + this.quoted(remoteSchemaName));
    }

    public ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(schemaName.orElse(null), null, this.escapeObjectNameForMetadataQuery(tableName, metadata.getSearchStringEscape()).orElse(null), this.getTableTypes().map(types -> (String[])types.toArray(String[]::new)).orElse(null));
    }

    protected ResultSet getAllTableColumns(Connection connection, Optional<String> remoteSchemaName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getColumns(remoteSchemaName.orElse(null), null, null, null);
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_CAT");
    }

    public Optional<String> getTableComment(ResultSet resultSet) throws SQLException {
        return Optional.ofNullable(Strings.emptyToNull((String)resultSet.getString("REMARKS")));
    }

    public void setTableComment(ConnectorSession session, JdbcTableHandle handle, Optional<String> comment) {
        String sql = String.format("ALTER TABLE %s COMMENT = %s", this.quoted(handle.asPlainTable().getRemoteTableName()), MariaDbClient.mariaDbVarcharLiteral(comment.orElse(NO_COMMENT)));
        this.execute(session, sql);
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        Optional<ColumnMapping> unsignedMapping = MariaDbClient.getUnsignedMapping(typeHandle);
        if (unsignedMapping.isPresent()) {
            return unsignedMapping;
        }
        switch (typeHandle.jdbcType()) {
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(ColumnMapping.longMapping((Type)RealType.REAL, (resultSet, columnIndex) -> Float.floatToRawIntBits(resultSet.getFloat(columnIndex)), (LongWriteFunction)StandardColumnMappings.realWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN));
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: 
            case 3: {
                int decimalDigits = typeHandle.requiredDecimalDigits();
                int precision = typeHandle.requiredColumnSize();
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && precision > 38) {
                    int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if ((precision += Math.max(-decimalDigits, 0)) > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.requiredColumnSize(), (boolean)false));
            }
            case -1: 
            case 12: {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.requiredColumnSize(), (boolean)false));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (SliceReadFunction)StandardColumnMappings.varbinaryReadFunction(), (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN));
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, (LongReadFunction)StandardColumnMappings.dateReadFunctionUsingLocalDate(), (LongWriteFunction)MariaDbClient.dateWriteFunction()));
            }
            case 92: {
                TimeType timeType = TimeType.createTimeType((int)MariaDbClient.getTimePrecision(typeHandle.requiredColumnSize()));
                return Optional.of(StandardColumnMappings.timeColumnMapping((TimeType)timeType));
            }
            case 93: {
                TimestampType timestampType = TimestampType.createTimestampType((int)MariaDbClient.getTimestampPrecision(typeHandle.requiredColumnSize()));
                return Optional.of(StandardColumnMappings.timestampColumnMapping((TimestampType)timestampType));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return MariaDbClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    private static int getTimestampPrecision(int timestampColumnSize) {
        if (timestampColumnSize == 19) {
            return 0;
        }
        int timestampPrecision = timestampColumnSize - 19 - 1;
        Verify.verify((1 <= timestampPrecision && timestampPrecision <= 6 ? 1 : 0) != 0, (String)"Unexpected timestamp precision %s calculated from timestamp column size %s", (int)timestampPrecision, (int)timestampColumnSize);
        return timestampPrecision;
    }

    private static int getTimePrecision(int timeColumnSize) {
        if (timeColumnSize == 10) {
            return 0;
        }
        int timePrecision = timeColumnSize - 10 - 1;
        Verify.verify((1 <= timePrecision && timePrecision <= 6 ? 1 : 0) != 0, (String)"Unexpected time precision %s calculated from time column size %s", (int)timePrecision, (int)timeColumnSize);
        return timePrecision;
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return WriteMapping.sliceMapping((String)("char(" + charType.getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            String dataType = varcharType.isUnbounded() ? "longtext" : (varcharType.getBoundedLength() <= 255 ? "tinytext" : (varcharType.getBoundedLength() <= 65535 ? "text" : (varcharType.getBoundedLength() <= 0xFFFFFF ? "mediumtext" : "longtext")));
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type == VarbinaryType.VARBINARY) {
            return WriteMapping.sliceMapping((String)"mediumblob", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)MariaDbClient.dateWriteFunction());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            if (timeType.getPrecision() <= 6) {
                return WriteMapping.longMapping((String)String.format("time(%s)", timeType.getPrecision()), (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)timeType.getPrecision()));
            }
            return WriteMapping.longMapping((String)String.format("time(%s)", 6), (LongWriteFunction)StandardColumnMappings.timeWriteFunction((int)6));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.getPrecision() <= 6) {
                Verify.verify((timestampType.getPrecision() <= 6 ? 1 : 0) != 0);
                return WriteMapping.longMapping((String)String.format("timestamp(%s)", timestampType.getPrecision()), (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((TimestampType)timestampType));
            }
            return WriteMapping.objectMapping((String)String.format("timestamp(%s)", 6), (ObjectWriteFunction)StandardColumnMappings.longTimestampWriteFunction((TimestampType)timestampType, (int)6));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column, ColumnPosition position) {
        Verify.verify((boolean)handle.getAuthorization().isEmpty(), (String)"Unexpected authorization is required for table: %s", (Object)handle);
        RemoteTableName table = handle.asPlainTable().getRemoteTableName();
        ColumnPosition columnPosition = position;
        Objects.requireNonNull(columnPosition);
        ColumnPosition columnPosition2 = columnPosition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ColumnPosition.First.class, ColumnPosition.After.class, ColumnPosition.Last.class}, (ColumnPosition)columnPosition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                this.addColumn(session, table, column, "FIRST");
                break;
            }
            case 1: {
                ColumnPosition.After after = (ColumnPosition.After)columnPosition2;
                this.addColumn(session, table, column, "AFTER " + this.quoted(after.columnName()));
                break;
            }
            case 2: {
                this.addColumn(session, table, column, NO_COMMENT);
            }
        }
    }

    private void addColumn(ConnectorSession session, RemoteTableName table, ColumnMetadata column, String position) {
        if (column.getComment() != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with comments");
        }
        try (Connection connection = this.connectionFactory.openConnection(session);){
            Verify.verify((boolean)connection.getAutoCommit());
            String columnName = column.getName();
            this.verifyColumnName(connection.getMetaData(), columnName);
            String remoteColumnName = this.getIdentifierMapping().toRemoteColumnName(this.getRemoteIdentifiers(connection), columnName);
            String sql = String.format("ALTER TABLE %s ADD %s %s", this.quoted(table), this.getColumnDefinitionSql(session, column, remoteColumnName), position);
            this.execute(session, connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void renameColumn(ConnectorSession session, Connection connection, RemoteTableName remoteTableName, String remoteColumnName, String newRemoteColumnName) throws SQLException {
        try {
            String sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(remoteTableName.getCatalogName().orElse(null), remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()), this.quoted(remoteColumnName), this.quoted(newRemoteColumnName));
            this.execute(session, connection, sql);
        }
        catch (SQLSyntaxErrorException syntaxError) {
            if (syntaxError.getErrorCode() == 1064) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Rename column not supported for the MariaDB server version", (Throwable)syntaxError);
            }
            throw syntaxError;
        }
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    public void dropNotNullConstraint(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping a not null constraint");
    }

    protected void copyTableSchema(ConnectorSession session, Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String tableCopyFormat = "CREATE TABLE %s AS SELECT * FROM %s WHERE 0 = 1";
        String sql = String.format(tableCopyFormat, this.quoted(catalogName, schemaName, newTableName), this.quoted(catalogName, schemaName, tableName));
        try {
            this.execute(session, connection, sql);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected List<String> createTableSqls(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        return ImmutableList.of((Object)String.format("CREATE TABLE %s (%s) COMMENT %s", this.quoted(remoteTableName), String.join((CharSequence)", ", columns), MariaDbClient.mariaDbVarcharLiteral(tableMetadata.getComment().orElse(NO_COMMENT))));
    }

    private static String mariaDbVarcharLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        return "'" + value.replace("'", "''").replace("\\", "\\\\") + "'";
    }

    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        Verify.verify((boolean)remoteTableName.getSchemaName().isEmpty());
        this.renameTable(session, null, remoteTableName.getCatalogName().orElse(null), remoteTableName.getTableName(), newTableName);
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        for (JdbcSortItem sortItem : sortOrder) {
            Type sortItemType = sortItem.column().getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType)) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().flatMap(sortItem -> {
                String ordering = sortItem.sortOrder().isAscending() ? "ASC" : "DESC";
                String columnSorting = String.format("%s %s", this.quoted(sortItem.column().getColumnName()), ordering);
                return switch (sortItem.sortOrder()) {
                    default -> throw new MatchException(null, null);
                    case SortOrder.ASC_NULLS_FIRST, SortOrder.DESC_NULLS_LAST -> Stream.of(columnSorting);
                    case SortOrder.ASC_NULLS_LAST -> Stream.of(String.format("ISNULL(%s) ASC", this.quoted(sortItem.column().getColumnName())), columnSorting);
                    case SortOrder.DESC_NULLS_FIRST -> Stream.of(String.format("ISNULL(%s) DESC", this.quoted(sortItem.column().getColumnName())), columnSorting);
                };
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s LIMIT %s", query, orderBy, limit);
        });
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return super.implementJoin(session, joinType, leftSource, leftProjections, rightSource, rightProjections, joinConditions, statistics);
    }

    public Optional<PreparedQuery> legacyImplementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return super.legacyImplementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics);
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        if (joinCondition.getOperator() == JoinCondition.Operator.IDENTICAL) {
            return false;
        }
        return Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).noneMatch(type -> type instanceof CharType || type instanceof VarcharType);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        if (!this.statisticsEnabled) {
            return TableStatistics.empty();
        }
        if (!handle.isNamedRelation()) {
            return TableStatistics.empty();
        }
        try {
            return this.readTableStatistics(session, handle);
        }
        catch (RuntimeException | SQLException e) {
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed fetching statistics for table: " + String.valueOf(handle), (Throwable)e);
        }
    }

    private TableStatistics readTableStatistics(ConnectorSession session, JdbcTableHandle table) throws SQLException {
        Preconditions.checkArgument((boolean)table.isNamedRelation(), (String)"Relation is not a table: %s", (Object)table);
        log.debug("Reading statistics for %s", new Object[]{table});
        try (Connection connection = this.connectionFactory.openConnection(session);){
            TableStatistics tableStatistics;
            block26: {
                Map<String, ColumnIndexStatistics> columnStatisticsFromIndexes;
                ImmutableMap columnStatistics;
                TableStatistics.Builder tableStatistics2;
                Long rowCount;
                Handle handle;
                block24: {
                    TableStatistics tableStatistics3;
                    block25: {
                        Long indexMaxCardinality;
                        StatisticsDao statisticsDao;
                        block22: {
                            TableStatistics tableStatistics4;
                            block23: {
                                handle = Jdbi.open((Connection)connection);
                                statisticsDao = new StatisticsDao(handle);
                                rowCount = statisticsDao.getTableRowCount(table);
                                indexMaxCardinality = statisticsDao.getTableMaxColumnIndexCardinality(table);
                                log.debug("Estimated row count of table %s is %s, and max index cardinality is %s", new Object[]{table, rowCount, indexMaxCardinality});
                                if (rowCount != null && rowCount == 0L) {
                                    rowCount = null;
                                }
                                if (rowCount != null || indexMaxCardinality != null) break block22;
                                tableStatistics4 = TableStatistics.empty();
                                if (handle == null) break block23;
                                handle.close();
                            }
                            return tableStatistics4;
                        }
                        rowCount = Math.max((Long)MoreObjects.firstNonNull((Object)rowCount, (Object)0L), (Long)MoreObjects.firstNonNull((Object)indexMaxCardinality, (Object)0L));
                        tableStatistics2 = TableStatistics.builder();
                        tableStatistics2.setRowCount(Estimate.of((double)rowCount.longValue()));
                        columnStatistics = ImmutableMap.of();
                        columnStatisticsFromIndexes = statisticsDao.getColumnIndexStatistics(table);
                        if (!columnStatistics.isEmpty() || !columnStatisticsFromIndexes.isEmpty()) break block24;
                        log.debug("No column and index statistics read");
                        tableStatistics3 = tableStatistics2.build();
                        if (handle == null) break block25;
                        handle.close();
                    }
                    return tableStatistics3;
                }
                try {
                    for (JdbcColumnHandle column : JdbcMetadata.getColumns((ConnectorSession)session, (JdbcClient)this, (JdbcTableHandle)table)) {
                        ColumnIndexStatistics columnIndexStatistics;
                        ColumnStatistics.Builder columnStatisticsBuilder = ColumnStatistics.builder();
                        String columnName = column.getColumnName();
                        AnalyzeColumnStatistics analyzeColumnStatistics = (AnalyzeColumnStatistics)columnStatistics.get(columnName);
                        if (analyzeColumnStatistics != null) {
                            log.debug("Reading column statistics for %s, %s from analayze's column statistics: %s", new Object[]{table, columnName, analyzeColumnStatistics});
                            columnStatisticsBuilder.setNullsFraction(Estimate.of((double)analyzeColumnStatistics.nullsRatio()));
                        }
                        if ((columnIndexStatistics = columnStatisticsFromIndexes.get(columnName)) != null) {
                            log.debug("Reading column statistics for %s, %s from index statistics: %s", new Object[]{table, columnName, columnIndexStatistics});
                            columnStatisticsBuilder.setDistinctValuesCount(Estimate.of((double)columnIndexStatistics.cardinality()));
                            if (!columnIndexStatistics.nullable()) {
                                double knownNullFraction = columnStatisticsBuilder.build().getNullsFraction().getValue();
                                if (knownNullFraction > 0.0) {
                                    log.warn("Inconsistent statistics, null fraction for a column %s, %s, that is not nullable according to index statistics: %s", new Object[]{table, columnName, knownNullFraction});
                                }
                                columnStatisticsBuilder.setNullsFraction(Estimate.zero());
                            }
                            rowCount = Math.max(rowCount, columnIndexStatistics.cardinality());
                        }
                        tableStatistics2.setColumnStatistics((ColumnHandle)column, columnStatisticsBuilder.build());
                    }
                    tableStatistics2.setRowCount(Estimate.of((double)rowCount.longValue()));
                    tableStatistics = tableStatistics2.build();
                    if (handle == null) break block26;
                }
                catch (Throwable throwable) {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handle.close();
            }
            return tableStatistics;
        }
    }

    private static LongWriteFunction dateWriteFunction() {
        return (statement, index, day) -> statement.setString(index, DATE_FORMATTER.format(LocalDate.ofEpochDay(day)));
    }

    private static Optional<ColumnMapping> getUnsignedMapping(JdbcTypeHandle typeHandle) {
        if (typeHandle.jdbcTypeName().isEmpty()) {
            return Optional.empty();
        }
        String typeName = (String)typeHandle.jdbcTypeName().get();
        if (typeName.equalsIgnoreCase("tinyint unsigned")) {
            return Optional.of(StandardColumnMappings.smallintColumnMapping());
        }
        if (typeName.equalsIgnoreCase("smallint unsigned")) {
            return Optional.of(StandardColumnMappings.integerColumnMapping());
        }
        if (typeName.equalsIgnoreCase("int unsigned")) {
            return Optional.of(StandardColumnMappings.bigintColumnMapping());
        }
        if (typeName.equalsIgnoreCase("bigint unsigned")) {
            return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)20)));
        }
        return Optional.empty();
    }

    private static class StatisticsDao {
        private final Handle handle;

        public StatisticsDao(Handle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        Long getTableRowCount(JdbcTableHandle table) {
            RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
            return ((Query)((Query)this.handle.createQuery("SELECT TABLE_ROWS FROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_SCHEMA = :schema AND TABLE_NAME = :table_name\nAND TABLE_TYPE = 'BASE TABLE'\n").bind("schema", (String)remoteTableName.getCatalogName().orElse(null))).bind("table_name", remoteTableName.getTableName())).mapTo(Long.class).findOne().orElse(null);
        }

        Long getTableMaxColumnIndexCardinality(JdbcTableHandle table) {
            RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
            return ((Query)((Query)this.handle.createQuery("SELECT max(CARDINALITY) AS row_count FROM INFORMATION_SCHEMA.STATISTICS\nWHERE TABLE_SCHEMA = :schema AND TABLE_NAME = :table_name\n").bind("schema", (String)remoteTableName.getCatalogName().orElse(null))).bind("table_name", remoteTableName.getTableName())).mapTo(Long.class).findOne().orElse(null);
        }

        Map<String, AnalyzeColumnStatistics> getColumnStatistics(JdbcTableHandle table) {
            RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
            return (Map)((Query)((Query)this.handle.createQuery("    SELECT\n        column_name,\n        -- TODO min_value, max_value,\n        nulls_ratio\n    FROM mysql.column_stats\n    WHERE db_name = :database AND TABLE_NAME = :table_name\n    AND nulls_ratio IS NOT NULL\n").bind("database", (String)remoteTableName.getCatalogName().orElse(null))).bind("table_name", remoteTableName.getTableName())).map((rs, ctx) -> {
                String columnName = rs.getString("column_name");
                double nullsRatio = rs.getDouble("nulls_ratio");
                return Map.entry(columnName, new AnalyzeColumnStatistics(nullsRatio));
            }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        Map<String, ColumnIndexStatistics> getColumnIndexStatistics(JdbcTableHandle table) {
            RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
            return (Map)((Query)((Query)this.handle.createQuery("SELECT\n    COLUMN_NAME,\n    MAX(NULLABLE) AS NULLABLE,\n    MAX(CARDINALITY) AS CARDINALITY\nFROM INFORMATION_SCHEMA.STATISTICS\nWHERE TABLE_SCHEMA = :schema AND TABLE_NAME = :table_name\nAND SEQ_IN_INDEX = 1 -- first column in the index\nAND SUB_PART IS NULL -- ignore cases where only a column prefix is indexed\nAND CARDINALITY IS NOT NULL -- CARDINALITY might be null (https://stackoverflow.com/a/42242729/65458)\nAND CARDINALITY != 0 -- CARDINALITY is initially 0 until analyzed\nGROUP BY COLUMN_NAME -- there might be multiple indexes on a column\n").bind("schema", (String)remoteTableName.getCatalogName().orElse(null))).bind("table_name", remoteTableName.getTableName())).map((rs, ctx) -> {
                String columnName = rs.getString("COLUMN_NAME");
                boolean nullable = rs.getString("NULLABLE").equalsIgnoreCase("YES");
                Preconditions.checkState((!rs.wasNull() ? 1 : 0) != 0, (Object)"NULLABLE is null");
                long cardinality = rs.getLong("CARDINALITY");
                Preconditions.checkState((!rs.wasNull() ? 1 : 0) != 0, (Object)"CARDINALITY is null");
                return Map.entry(columnName, new ColumnIndexStatistics(nullable, cardinality));
            }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    private record AnalyzeColumnStatistics(double nullsRatio) {
    }

    private record ColumnIndexStatistics(boolean nullable, long cardinality) {
    }
}

