/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mariadb;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.plugin.mariadb.MariaDbClient;
import io.trino.plugin.mariadb.MariaDbJdbcConfig;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.sql.Driver;
import java.util.Properties;

public class MariaDbClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(MariaDbClient.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(JdbcMetadataConfig.class, config -> config.setBulkListColumns(true));
        ConfigBinder.configBinder((Binder)binder).bindConfig(MariaDbJdbcConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcStatisticsConfig.class);
        binder.install((Module)new DecimalModule());
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory createConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider, OpenTelemetry openTelemetry) {
        return DriverConnectionFactory.builder((Driver)new org.mariadb.jdbc.Driver(), (String)config.getConnectionUrl(), (CredentialProvider)credentialProvider).setConnectionProperties(MariaDbClientModule.getConnectionProperties()).setOpenTelemetry(openTelemetry).build();
    }

    private static Properties getConnectionProperties() {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("tinyInt1isBit", "false");
        return connectionProperties;
    }
}

