/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.transport.internal;

import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.transport.internal.HttpConnectionOverHTTP2;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HTTPSessionListenerPromise
implements Session.Listener,
Promise<Session> {
    private final AtomicMarkableReference<HttpConnectionOverHTTP2> connection = new AtomicMarkableReference<Object>(null, false);
    private final Map<String, Object> context;

    public HTTPSessionListenerPromise(Map<String, Object> context) {
        this.context = context;
    }

    public void succeeded(Session session) {
    }

    public void failed(Throwable failure) {
        this.failConnectionPromise(failure);
    }

    private Destination destination() {
        return (Destination)this.context.get("org.eclipse.jetty.client.destination");
    }

    private Promise<Connection> httpConnectionPromise() {
        return (Promise)this.context.get("org.eclipse.jetty.client.connection.promise");
    }

    public void onSettings(Session session, SettingsFrame frame) {
        if (!this.connection.isMarked()) {
            this.onServerPreface(session);
        }
    }

    private void onServerPreface(Session session) {
        HTTP2Connection http2Connection;
        Destination destination = this.destination();
        HttpConnectionOverHTTP2 connection = (HttpConnectionOverHTTP2)this.newConnection(destination, session, http2Connection = (HTTP2Connection)this.context.get(HTTP2Connection.class.getName()));
        if (this.connection.compareAndSet(null, connection, false, true)) {
            ConnectionPool connectionPool = destination.getConnectionPool();
            if (connectionPool instanceof AbstractConnectionPool) {
                AbstractConnectionPool pool = (AbstractConnectionPool)connectionPool;
                connection.setMaxUsage(pool.getMaxUsage());
            }
            this.httpConnectionPromise().succeeded((Object)connection);
        }
    }

    protected Connection newConnection(Destination destination, Session session, HTTP2Connection connection) {
        return new HttpConnectionOverHTTP2(destination, session, connection);
    }

    public void onGoAway(Session session, GoAwayFrame frame) {
        HttpConnectionOverHTTP2 connection;
        if (!this.failConnectionPromise(new ClosedChannelException()) && (connection = this.getConnection()) != null) {
            connection.remove();
        }
    }

    public void onClose(Session session, GoAwayFrame frame, Callback callback) {
        HttpConnectionOverHTTP2 connection;
        if (!this.failConnectionPromise(new ClosedChannelException()) && (connection = this.getConnection()) != null) {
            this.onClose(connection, frame);
        }
        callback.succeeded();
    }

    public void onClose(HttpConnectionOverHTTP2 connection, GoAwayFrame frame) {
        connection.close();
    }

    public boolean onIdleTimeout(Session session) {
        long idleTimeout = ((HTTP2Session)session).getEndPoint().getIdleTimeout();
        TimeoutException failure = new TimeoutException("Idle timeout expired: " + idleTimeout + " ms");
        if (this.failConnectionPromise(failure)) {
            return true;
        }
        HttpConnectionOverHTTP2 connection = this.getConnection();
        if (connection != null) {
            return connection.onIdleTimeout(idleTimeout, failure);
        }
        return true;
    }

    public void onFailure(Session session, Throwable failure, Callback callback) {
        HttpConnectionOverHTTP2 connection;
        if (!this.failConnectionPromise(failure) && (connection = this.getConnection()) != null) {
            connection.close(failure);
        }
        callback.succeeded();
    }

    private boolean failConnectionPromise(Throwable failure) {
        boolean result = this.connection.compareAndSet(null, null, false, true);
        if (result) {
            this.httpConnectionPromise().failed(failure);
        }
        return result;
    }

    private HttpConnectionOverHTTP2 getConnection() {
        return this.connection.getReference();
    }
}

