/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import io.trino.plugin.faker.Literal;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public record FakerColumnHandle(int columnIndex, String name, Type type, double nullProbability, String generator, Domain domain, ValueSet step) implements ColumnHandle
{
    public FakerColumnHandle {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(domain, "domain is null");
        Objects.requireNonNull(step, "step is null");
        Preconditions.checkState((step.isNone() || step.isSingleValue() ? 1 : 0) != 0, (Object)"step must be a single value");
    }

    public static FakerColumnHandle of(int columnId, ColumnMetadata column, double defaultNullProbability) {
        String generator;
        double nullProbability = 0.0;
        if (column.isNullable()) {
            nullProbability = column.getProperties().getOrDefault("null_probability", defaultNullProbability);
        }
        if ((generator = (String)column.getProperties().get("generator")) != null && !FakerColumnHandle.isCharacterColumn(column)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property can only be set for CHAR, VARCHAR or VARBINARY columns".formatted("generator"));
        }
        Object min = FakerColumnHandle.propertyValue(column, "min");
        Object max = FakerColumnHandle.propertyValue(column, "max");
        Domain domain = Domain.all((Type)column.getType());
        if (min != null || max != null) {
            if (FakerColumnHandle.isCharacterColumn(column)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` and `%s` properties cannot be set for CHAR, VARCHAR or VARBINARY columns".formatted("min", "max"));
            }
            domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)FakerColumnHandle.range(column.getType(), min, max), (Range[])new Range[0]), (boolean)false);
        }
        if (column.getProperties().containsKey("allowed_values")) {
            if (min != null || max != null || generator != null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property cannot be set together with `%s`, `%s`, and `%s` properties".formatted("allowed_values", "min", "max", "generator"));
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : FakerColumnHandle.strings((List)column.getProperties().get("allowed_values"))) {
                try {
                    builder.add(Literal.parse(value, column.getType()));
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property must only contain valid %s literals, failed to parse `%s`".formatted("allowed_values", column.getType().getDisplayName(), value), (Throwable)e);
                }
            }
            domain = Domain.create((ValueSet)ValueSet.copyOf((Type)column.getType(), (Collection)builder.build()), (boolean)false);
        }
        return new FakerColumnHandle(columnId, column.getName(), column.getType(), nullProbability, generator, domain, FakerColumnHandle.stepValue(column));
    }

    private static boolean isCharacterColumn(ColumnMetadata column) {
        return column.getType() instanceof CharType || column.getType() instanceof VarcharType || column.getType() instanceof VarbinaryType;
    }

    private static Object propertyValue(ColumnMetadata column, String property) {
        try {
            return Literal.parse((String)column.getProperties().get(property), column.getType());
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property must be a valid %s literal".formatted(property, column.getType().getDisplayName()), (Throwable)e);
        }
    }

    private static ValueSet stepValue(ColumnMetadata column) {
        Type type = column.getType();
        String rawStep = (String)column.getProperties().get("step");
        if (rawStep == null) {
            return ValueSet.none((Type)type);
        }
        if (FakerColumnHandle.isCharacterColumn(column)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property cannot be set for CHAR, VARCHAR or VARBINARY columns".formatted("step"));
        }
        if (DateType.DATE.equals((Object)column.getType()) || type instanceof TimestampType || type instanceof TimestampWithTimeZoneType || type instanceof TimeType || type instanceof TimeWithTimeZoneType) {
            try {
                return ValueSet.of((Type)BigintType.BIGINT, (Object)Duration.valueOf((String)rawStep).roundTo(TimeUnit.NANOSECONDS), (Object[])new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property for a %s column must be a valid duration literal".formatted("step", column.getType().getDisplayName()), (Throwable)e);
            }
        }
        try {
            return ValueSet.of((Type)type, (Object)Literal.parse(rawStep, type), (Object[])new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_PROPERTY, "The `%s` property for a %s column must be a valid %s literal".formatted("step", column.getType().getDisplayName(), type.getDisplayName()), (Throwable)e);
        }
    }

    private static Range range(Type type, Object min, Object max) {
        Objects.requireNonNull(type, "type is null");
        if (min == null && max == null) {
            return Range.all((Type)type);
        }
        if (max == null) {
            return Range.greaterThanOrEqual((Type)type, (Object)min);
        }
        if (min == null) {
            return Range.lessThanOrEqual((Type)type, (Object)max);
        }
        return Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true);
    }

    private static List<String> strings(Collection<?> values) {
        return (List)values.stream().map(String.class::cast).collect(ImmutableList.toImmutableList());
    }
}

