/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Locale;

public class FakerConfig {
    private double nullProbability = 0.5;
    private long defaultLimit = 1000L;
    private Locale locale = Locale.ENGLISH;

    @Max(value=1L)
    @Min(value=0L)
    public @Max(value=1L) @Min(value=0L) double getNullProbability() {
        return this.nullProbability;
    }

    @Config(value="faker.null-probability")
    @ConfigDescription(value="Default null probability for any column in any table that allows them")
    public FakerConfig setNullProbability(double value) {
        this.nullProbability = value;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getDefaultLimit() {
        return this.defaultLimit;
    }

    @Config(value="faker.default-limit")
    @ConfigDescription(value="Default number of rows for each table, when the LIMIT clause is not specified in the query")
    public FakerConfig setDefaultLimit(long value) {
        this.defaultLimit = value;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Config(value="faker.locale")
    @ConfigDescription(value="Default locale for generating character based data, specified as a IETF BCP 47 language tag string")
    public FakerConfig setLocale(String value) {
        this.locale = new Locale.Builder().setLanguageTag(value).build();
        return this;
    }
}

