/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.base.Versions;
import io.trino.plugin.faker.FakerConnector;
import io.trino.plugin.faker.FakerModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;

public class FakerConnectorFactory
implements ConnectorFactory {
    private final String name;

    public FakerConnectorFactory(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Objects.requireNonNull(context, "context is null");
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap(new Module[]{new FakerModule(context.getNodeManager(), context.getTypeManager())});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
        return (Connector)injector.getInstance(FakerConnector.class);
    }
}

