/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.annotations.ScalarFromAnnotationsParser;
import io.trino.plugin.faker.FakerFunctions;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import java.util.List;

public class FakerFunctionProvider
implements FunctionProvider {
    private final List<SqlScalarFunction> functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(FakerFunctions.class);

    @Inject
    public FakerFunctionProvider() {
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
        return this.functions.stream().filter(function -> function.getFunctionMetadata().getFunctionId().equals((Object)functionId)).map(function -> function.specialize(boundSignature, functionDependencies)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown function " + String.valueOf(functionId))).getScalarFunctionImplementation(invocationConvention);
    }

    public List<FunctionMetadata> functionsMetadata() {
        return (List)this.functions.stream().map(SqlScalarFunction::getFunctionMetadata).collect(ImmutableList.toImmutableList());
    }
}

