/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.slice.Slice;
import io.trino.plugin.faker.ColumnInfo;
import io.trino.plugin.faker.FakerColumnHandle;
import io.trino.plugin.faker.FakerConfig;
import io.trino.plugin.faker.FakerFunctionProvider;
import io.trino.plugin.faker.FakerOutputTableHandle;
import io.trino.plugin.faker.FakerTableHandle;
import io.trino.plugin.faker.SchemaInfo;
import io.trino.plugin.faker.TableInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FakerMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "default";
    public static final String ROW_ID_COLUMN_NAME = "$row_id";
    @GuardedBy(value="this")
    private final List<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
    private final double nullProbability;
    private final long defaultLimit;
    private final FakerFunctionProvider functionsProvider;
    @GuardedBy(value="this")
    private final Map<SchemaTableName, TableInfo> tables = new HashMap<SchemaTableName, TableInfo>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, ConnectorViewDefinition> views = new HashMap<SchemaTableName, ConnectorViewDefinition>();

    @Inject
    public FakerMetadata(FakerConfig config, FakerFunctionProvider functionProvider) {
        this.schemas.add(new SchemaInfo(SCHEMA_NAME, Map.of()));
        this.nullProbability = config.getNullProbability();
        this.defaultLimit = config.getDefaultLimit();
        this.functionsProvider = Objects.requireNonNull(functionProvider, "functionProvider is null");
    }

    public synchronized List<String> listSchemaNames(ConnectorSession connectorSession) {
        return (List)this.schemas.stream().map(SchemaInfo::name).collect(ImmutableList.toImmutableList());
    }

    public synchronized void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        if (this.schemas.stream().anyMatch(schema -> schema.name().equals(schemaName))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_ALREADY_EXISTS, String.format("Schema '%s' already exists", schemaName));
        }
        this.schemas.add(new SchemaInfo(schemaName, properties));
    }

    public synchronized void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        Verify.verify((boolean)this.schemas.remove(this.getSchema(schemaName)));
    }

    private synchronized SchemaInfo getSchema(String name) {
        Optional<SchemaInfo> schema = this.schemas.stream().filter(schemaInfo -> schemaInfo.name().equals(name)).findAny();
        if (schema.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", name));
        }
        return schema.get();
    }

    public synchronized ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        SchemaInfo schema = this.getSchema(tableName.getSchemaName());
        TableInfo tableInfo = this.tables.get(tableName);
        if (tableInfo == null) {
            return null;
        }
        long schemaLimit = (Long)schema.properties().getOrDefault("default_limit", this.defaultLimit);
        long tableLimit = (Long)this.tables.get(tableName).properties().getOrDefault("default_limit", schemaLimit);
        return new FakerTableHandle(tableName, tableLimit);
    }

    public synchronized ConnectorTableMetadata getTableMetadata(ConnectorSession connectorSession, ConnectorTableHandle connectorTableHandle) {
        FakerTableHandle tableHandle = (FakerTableHandle)connectorTableHandle;
        SchemaTableName name = tableHandle.schemaTableName();
        TableInfo tableInfo = this.tables.get(tableHandle.schemaTableName());
        return new ConnectorTableMetadata(name, (List)tableInfo.columns().stream().map(ColumnInfo::metadata).collect(ImmutableList.toImmutableList()), tableInfo.properties(), tableInfo.comment());
    }

    public synchronized List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return (List)Stream.concat(this.tables.keySet().stream(), this.views.keySet().stream()).filter(table -> schemaName.map(table.getSchemaName()::contentEquals).orElse(true)).collect(ImmutableList.toImmutableList());
    }

    public synchronized Map<String, ColumnHandle> getColumnHandles(ConnectorSession connectorSession, ConnectorTableHandle connectorTableHandle) {
        FakerTableHandle tableHandle = (FakerTableHandle)connectorTableHandle;
        return (Map)this.tables.get(tableHandle.schemaTableName()).columns().stream().collect(ImmutableMap.toImmutableMap(ColumnInfo::name, ColumnInfo::handle));
    }

    public synchronized ColumnMetadata getColumnMetadata(ConnectorSession connectorSession, ConnectorTableHandle connectorTableHandle, ColumnHandle columnHandle) {
        FakerTableHandle tableHandle = (FakerTableHandle)connectorTableHandle;
        return this.tables.get(tableHandle.schemaTableName()).column(columnHandle).metadata();
    }

    public synchronized Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        HashMap<SchemaTableName, RelationColumnsMetadata> relationColumns = new HashMap<SchemaTableName, RelationColumnsMetadata>();
        SchemaTablePrefix prefix = schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new);
        this.tables.entrySet().stream().filter(entry -> prefix.matches((SchemaTableName)entry.getKey())).forEach(entry -> {
            SchemaTableName name = (SchemaTableName)entry.getKey();
            RelationColumnsMetadata columns = RelationColumnsMetadata.forTable((SchemaTableName)name, (List)((List)((TableInfo)entry.getValue()).columns().stream().map(ColumnInfo::metadata).collect(ImmutableList.toImmutableList())));
            relationColumns.put(name, columns);
        });
        for (Map.Entry<SchemaTableName, ConnectorViewDefinition> entry2 : this.getViews(session, schemaName).entrySet()) {
            relationColumns.put(entry2.getKey(), RelationColumnsMetadata.forView((SchemaTableName)entry2.getKey(), (List)entry2.getValue().getColumns()));
        }
        return ((Set)relationFilter.apply(relationColumns.keySet())).stream().map(relationColumns::get).iterator();
    }

    public synchronized void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        FakerTableHandle handle = (FakerTableHandle)tableHandle;
        this.tables.remove(handle.schemaTableName());
    }

    public synchronized void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        this.checkSchemaExists(newTableName.getSchemaName());
        this.checkTableNotExists(newTableName);
        this.checkViewNotExists(newTableName);
        FakerTableHandle handle = (FakerTableHandle)tableHandle;
        SchemaTableName oldTableName = handle.schemaTableName();
        this.tables.put(newTableName, this.tables.remove(oldTableName));
    }

    public synchronized void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Optional<Object>> properties) {
        FakerTableHandle handle = (FakerTableHandle)tableHandle;
        SchemaTableName tableName = handle.schemaTableName();
        TableInfo oldInfo = this.tables.get(tableName);
        Map<String, Object> newProperties = Stream.concat(oldInfo.properties().entrySet().stream().filter(entry -> !properties.containsKey(entry.getKey())), properties.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.tables.put(tableName, oldInfo.withProperties(newProperties));
    }

    public synchronized void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        FakerTableHandle handle = (FakerTableHandle)tableHandle;
        SchemaTableName tableName = handle.schemaTableName();
        TableInfo oldInfo = Objects.requireNonNull(this.tables.get(tableName), "tableInfo is null");
        this.tables.put(tableName, oldInfo.withComment(comment));
    }

    public synchronized void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        FakerTableHandle handle = (FakerTableHandle)tableHandle;
        SchemaTableName tableName = handle.schemaTableName();
        TableInfo oldInfo = this.tables.get(tableName);
        List columns = (List)oldInfo.columns().stream().map(columnInfo -> {
            if (columnInfo.handle().equals(column)) {
                if (ROW_ID_COLUMN_NAME.equals(columnInfo.handle().name())) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_REFERENCE, "Cannot set comment for %s column".formatted(ROW_ID_COLUMN_NAME));
                }
                return columnInfo.withComment(comment);
            }
            return columnInfo;
        }).collect(ImmutableList.toImmutableList());
        this.tables.put(tableName, oldInfo.withColumns(columns));
    }

    public synchronized void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        if (saveMode == SaveMode.REPLACE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES, false);
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public synchronized FakerOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        int columnId;
        if (replace) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        SchemaTableName tableName = tableMetadata.getTable();
        SchemaInfo schema = this.getSchema(tableName.getSchemaName());
        this.checkTableNotExists(tableMetadata.getTable());
        this.checkViewNotExists(tableMetadata.getTable());
        double schemaNullProbability = (Double)schema.properties().getOrDefault("null_probability", this.nullProbability);
        double tableNullProbability = tableMetadata.getProperties().getOrDefault("null_probability", schemaNullProbability);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (columnId = 0; columnId < tableMetadata.getColumns().size(); ++columnId) {
            ColumnMetadata column = (ColumnMetadata)tableMetadata.getColumns().get(columnId);
            columns.add((Object)new ColumnInfo(FakerColumnHandle.of(columnId, column, tableNullProbability), column));
        }
        columns.add((Object)new ColumnInfo(new FakerColumnHandle(columnId, ROW_ID_COLUMN_NAME, (Type)BigintType.BIGINT, 0.0, "", Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)false), ValueSet.of((Type)BigintType.BIGINT, (Object)1L, (Object[])new Object[0])), ColumnMetadata.builder().setName(ROW_ID_COLUMN_NAME).setType((Type)BigintType.BIGINT).setHidden(true).setNullable(false).build()));
        this.tables.put(tableName, new TableInfo((List<ColumnInfo>)columns.build(), tableMetadata.getProperties(), tableMetadata.getComment()));
        return new FakerOutputTableHandle(tableName);
    }

    private synchronized void checkSchemaExists(String schemaName) {
        if (this.schemas.stream().noneMatch(schema -> schema.name().equals(schemaName))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
    }

    private synchronized void checkTableNotExists(SchemaTableName tableName) {
        if (this.tables.containsKey(tableName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, String.format("Table '%s' already exists", tableName));
        }
    }

    private synchronized void checkViewNotExists(SchemaTableName viewName) {
        if (this.views.containsKey(viewName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("View '%s' already exists", viewName));
        }
    }

    public synchronized Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        FakerOutputTableHandle fakerOutputHandle = (FakerOutputTableHandle)tableHandle;
        SchemaTableName tableName = fakerOutputHandle.schemaTableName();
        TableInfo info = this.tables.get(tableName);
        Objects.requireNonNull(info, "info is null");
        this.tables.put(tableName, new TableInfo(info.columns(), info.properties(), info.comment()));
        return Optional.empty();
    }

    public synchronized List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.views.keySet().stream().filter(table -> schemaName.map(table.getSchemaName()::equals).orElse(true)).collect(ImmutableList.toImmutableList());
    }

    public synchronized Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        SchemaTablePrefix prefix = schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new);
        return ImmutableMap.copyOf((Map)Maps.filterKeys(this.views, arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)));
    }

    public synchronized Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.ofNullable(this.views.get(viewName));
    }

    public synchronized void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, Map<String, Object> viewProperties, boolean replace) {
        Preconditions.checkArgument((boolean)viewProperties.isEmpty(), (Object)"This connector does not support creating views with properties");
        this.checkSchemaExists(viewName.getSchemaName());
        this.checkTableNotExists(viewName);
        if (replace) {
            this.views.put(viewName, definition);
        } else if (this.views.putIfAbsent(viewName, definition) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View '%s' already exists".formatted(viewName));
        }
    }

    public synchronized void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        ConnectorViewDefinition view = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        this.views.put(viewName, new ConnectorViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), view.getColumns(), comment, view.getOwner(), view.isRunAsInvoker(), view.getPath()));
    }

    public synchronized void setViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        ConnectorViewDefinition view = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        this.views.put(viewName, new ConnectorViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), (List)view.getColumns().stream().map(currentViewColumn -> columnName.equals(currentViewColumn.getName()) ? new ConnectorViewDefinition.ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), view.getComment(), view.getOwner(), view.isRunAsInvoker(), view.getPath()));
    }

    public synchronized void renameView(ConnectorSession session, SchemaTableName source, SchemaTableName target) {
        this.checkSchemaExists(target.getSchemaName());
        if (!this.views.containsKey(source)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "View not found: " + String.valueOf(source));
        }
        this.checkTableNotExists(target);
        if (this.views.putIfAbsent(target, this.views.remove(source)) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View '%s' already exists".formatted(target));
        }
    }

    public synchronized void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.views.remove(viewName) == null) {
            throw new ViewNotFoundException(viewName);
        }
    }

    public synchronized Map<String, Object> getSchemaProperties(ConnectorSession session, String schemaName) {
        Optional<SchemaInfo> schema = this.schemas.stream().filter(s -> s.name().equals(schemaName)).findAny();
        if (schema.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        return schema.get().properties();
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        FakerTableHandle fakerTable = (FakerTableHandle)table;
        if (fakerTable.limit() == limit) {
            return Optional.empty();
        }
        return Optional.of(new LimitApplicationResult((Object)fakerTable.withLimit(limit), false, true));
    }

    public Collection<FunctionMetadata> listFunctions(ConnectorSession session, String schemaName) {
        return this.functionsProvider.functionsMetadata();
    }

    public Collection<FunctionMetadata> getFunctions(ConnectorSession session, SchemaFunctionName name) {
        return (Collection)this.functionsProvider.functionsMetadata().stream().filter(function -> function.getCanonicalName().equals(name.getFunctionName())).collect(ImmutableList.toImmutableList());
    }

    public FunctionMetadata getFunctionMetadata(ConnectorSession session, FunctionId functionId) {
        return this.functionsProvider.functionsMetadata().stream().filter(function -> function.getFunctionId().equals((Object)functionId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown function " + String.valueOf(functionId)));
    }

    public FunctionDependencyDeclaration getFunctionDependencies(ConnectorSession session, FunctionId functionId, BoundSignature boundSignature) {
        return FunctionDependencyDeclaration.NO_DEPENDENCIES;
    }
}

