/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.faker.FakerColumnHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.Range;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.IpAddressType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.datafaker.Faker;

class FakerPageSource
implements ConnectorPageSource {
    static final long[] POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final int ROWS_PER_PAGE = 4096;
    private final Random random;
    private final Faker faker;
    private final SentenceGenerator sentenceGenerator;
    private final BoundedSentenceGenerator boundedSentenceGenerator;
    private final long limit;
    private final List<Generator> generators;
    private long completedRows;
    private final PageBuilder pageBuilder;
    private boolean closed;

    FakerPageSource(Faker faker, Random random, List<FakerColumnHandle> columns, long rowOffset, long limit) {
        this.faker = Objects.requireNonNull(faker, "faker is null");
        this.random = Objects.requireNonNull(random, "random is null");
        this.sentenceGenerator = () -> Slices.utf8Slice((String)faker.lorem().sentence(3 + random.nextInt(38)));
        this.boundedSentenceGenerator = maxLength -> Slices.utf8Slice((String)faker.lorem().maxLengthSentence(maxLength));
        List types = (List)Objects.requireNonNull(columns, "columns is null").stream().map(FakerColumnHandle::type).collect(ImmutableList.toImmutableList());
        this.limit = limit;
        this.generators = (List)columns.stream().map(column -> this.getGenerator((FakerColumnHandle)column, rowOffset)).collect(ImmutableList.toImmutableList());
        this.pageBuilder = new PageBuilder(types);
    }

    private Generator getGenerator(FakerColumnHandle column, long rowOffset) {
        if (column.domain().getValues().isDiscreteSet()) {
            List values = column.domain().getValues().getDiscreteSet();
            ObjectWriter singleValueWriter = this.objectWriter(column.type());
            return blockBuilder -> singleValueWriter.accept(blockBuilder, values.get(this.random.nextInt(values.size())));
        }
        Generator generator = !column.step().isNone() ? this.sequenceGenerator(column, rowOffset) : this.randomValueGenerator(column);
        if (column.nullProbability() == 0.0) {
            return generator;
        }
        return blockBuilder -> {
            if (this.random.nextDouble() <= column.nullProbability()) {
                blockBuilder.appendNull();
            } else {
                generator.accept(blockBuilder);
            }
        };
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.closed && this.pageBuilder.isEmpty();
    }

    public Page getNextPage() {
        if (!this.closed) {
            int positions = (int)Math.min(this.limit - this.completedRows, 4096L);
            if (positions <= 0) {
                this.closed = true;
            } else {
                this.pageBuilder.declarePositions(positions);
                for (int column = 0; column < this.generators.size(); ++column) {
                    BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(column);
                    Generator generator = this.generators.get(column);
                    for (int i = 0; i < positions; ++i) {
                        generator.accept(blockBuilder);
                    }
                }
                this.completedRows += (long)positions;
            }
        }
        if (this.closed && !this.pageBuilder.isEmpty() || this.pageBuilder.isFull()) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }

    public long getMemoryUsage() {
        return this.pageBuilder.getRetainedSizeInBytes();
    }

    public void close() {
        this.closed = true;
    }

    private Generator sequenceGenerator(FakerColumnHandle handle, final long rowOffset) {
        final SequenceWriter writer = this.sequenceWriter(handle);
        return new Generator(){
            long currentRowId;
            {
                this.currentRowId = rowOffset;
            }

            @Override
            public void accept(BlockBuilder blockBuilder) {
                writer.accept(blockBuilder, this.currentRowId++);
            }
        };
    }

    private SequenceWriter sequenceWriter(FakerColumnHandle handle) {
        Range genericRange = handle.domain().getValues().getRanges().getSpan();
        Type type = handle.type();
        if (BigintType.BIGINT.equals((Object)type)) {
            LongRange range = LongRange.of(genericRange, 1L, (Long)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> BigintType.BIGINT.writeLong(blockBuilder, range.at(rowId));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange, (Long)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> IntegerType.INTEGER.writeLong(blockBuilder, range.at(rowId));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange, -32768L, 32767L, (Long)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> SmallintType.SMALLINT.writeLong(blockBuilder, range.at(rowId));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange, -128L, 127L, (Long)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> TinyintType.TINYINT.writeLong(blockBuilder, range.at(rowId));
        }
        if (DateType.DATE.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange, (Long)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> DateType.DATE.writeLong(blockBuilder, range.at(rowId, 86400000000000L));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                ShortDecimalRange range = ShortDecimalRange.of(genericRange, decimalType.getPrecision(), (Long)handle.step().getSingleValue());
                return (blockBuilder, rowId) -> decimalType.writeLong(blockBuilder, range.at(rowId));
            }
            Int128Range range = Int128Range.of(genericRange, (Int128)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> decimalType.writeObject(blockBuilder, (Object)range.at(rowId));
        }
        if (RealType.REAL.equals((Object)type)) {
            FloatRange range = FloatRange.of(genericRange, Float.intBitsToFloat(Math.toIntExact((Long)handle.step().getSingleValue())));
            return (blockBuilder, rowId) -> RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(range.at(rowId)));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            DoubleRange range = DoubleRange.of(genericRange, (Double)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> DoubleType.DOUBLE.writeDouble(blockBuilder, range.at(rowId));
        }
        if (IntervalDayTimeType.INTERVAL_DAY_TIME.equals((Object)type) || IntervalYearMonthType.INTERVAL_YEAR_MONTH.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange, (Long)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> type.writeLong(blockBuilder, range.at(rowId));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.isShort()) {
                long factor = POWERS_OF_TEN[6 - timestampType.getPrecision()];
                LongRange range = LongRange.of(genericRange, factor, (Long)handle.step().getSingleValue());
                return (blockBuilder, rowId) -> timestampType.writeLong(blockBuilder, range.at(rowId, factor * 1000L) * factor);
            }
            LongTimestampRange range = LongTimestampRange.of(genericRange, timestampType.getPrecision(), (Long)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> timestampType.writeObject(blockBuilder, (Object)range.at(rowId, 1000L));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType tzType = (TimestampWithTimeZoneType)type;
            if (tzType.isShort()) {
                ShortTimestampWithTimeZoneRange range = ShortTimestampWithTimeZoneRange.of(genericRange, tzType.getPrecision(), (Long)handle.step().getSingleValue());
                return (blockBuilder, rowId) -> tzType.writeLong(blockBuilder, range.at(rowId, 1000000L));
            }
            LongTimestampWithTimeZoneRange range = LongTimestampWithTimeZoneRange.of(genericRange, tzType.getPrecision(), (Long)handle.step().getSingleValue());
            return (blockBuilder, rowId) -> tzType.writeObject(blockBuilder, (Object)range.at(rowId, 1000000L));
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            long factor = POWERS_OF_TEN[12 - timeType.getPrecision()];
            LongRange range = LongRange.of(genericRange, factor, 0L, 86400000000000000L, (Long)handle.step().getSingleValue() * 1000L);
            return (blockBuilder, rowId) -> timeType.writeLong(blockBuilder, range.at(rowId, factor) * factor);
        }
        if (type instanceof TimeWithTimeZoneType) {
            TimeWithTimeZoneType timeType = (TimeWithTimeZoneType)type;
            if (timeType.isShort()) {
                ShortTimeWithTimeZoneRange range = ShortTimeWithTimeZoneRange.of(genericRange, timeType.getPrecision(), (Long)handle.step().getSingleValue());
                return (blockBuilder, rowId) -> timeType.writeLong(blockBuilder, range.at(rowId));
            }
            LongTimeWithTimeZoneRange range = LongTimeWithTimeZoneRange.of(genericRange, timeType.getPrecision(), (Long)handle.step().getSingleValue() * 1000L);
            return (blockBuilder, rowId) -> timeType.writeObject(blockBuilder, (Object)range.at(rowId));
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
    }

    private Generator randomValueGenerator(FakerColumnHandle handle) {
        Range genericRange = handle.domain().getValues().getRanges().getSpan();
        if (handle.generator() != null) {
            if (!genericRange.isAll()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Predicates for columns with a generator expression are not supported");
            }
            return blockBuilder -> VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)this.faker.expression(handle.generator())));
        }
        Type type = handle.type();
        if (BigintType.BIGINT.equals((Object)type)) {
            LongRange range = LongRange.of(genericRange);
            return blockBuilder -> BigintType.BIGINT.writeLong(blockBuilder, this.numberBetween(range.low, range.high));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange);
            return blockBuilder -> IntegerType.INTEGER.writeLong(blockBuilder, (long)this.numberBetween(range.low, range.high));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange, -32768L, 32767L);
            return blockBuilder -> SmallintType.SMALLINT.writeLong(blockBuilder, (long)this.numberBetween(range.low, range.high));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange, -128L, 127L);
            return blockBuilder -> TinyintType.TINYINT.writeLong(blockBuilder, (long)this.numberBetween(range.low, range.high));
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            if (!genericRange.isAll()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Range or not a single value predicates for boolean columns are not supported");
            }
            return blockBuilder -> BooleanType.BOOLEAN.writeBoolean(blockBuilder, this.random.nextBoolean());
        }
        if (DateType.DATE.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange);
            return blockBuilder -> DateType.DATE.writeLong(blockBuilder, (long)this.numberBetween(range.low, range.high));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return this.decimalGenerator(genericRange, decimalType);
        }
        if (RealType.REAL.equals((Object)type)) {
            FloatRange range = FloatRange.of(genericRange);
            return blockBuilder -> RealType.REAL.writeLong(blockBuilder, (long)Float.floatToRawIntBits(range.low == range.high ? range.low : this.random.nextFloat(range.low, range.high)));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            DoubleRange range = DoubleRange.of(genericRange);
            return blockBuilder -> DoubleType.DOUBLE.writeDouble(blockBuilder, range.low == range.high ? range.low : this.random.nextDouble(range.low, range.high));
        }
        if (IntervalDayTimeType.INTERVAL_DAY_TIME.equals((Object)type)) {
            LongRange range = LongRange.of(genericRange);
            return blockBuilder -> IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(blockBuilder, this.numberBetween(range.low, range.high));
        }
        if (IntervalYearMonthType.INTERVAL_YEAR_MONTH.equals((Object)type)) {
            IntRange range = IntRange.of(genericRange);
            return blockBuilder -> IntervalYearMonthType.INTERVAL_YEAR_MONTH.writeLong(blockBuilder, (long)this.numberBetween(range.low, range.high));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return this.timestampGenerator(genericRange, timestampType);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            return this.timestampWithTimeZoneGenerator(genericRange, timestampWithTimeZoneType);
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            long factor = POWERS_OF_TEN[12 - timeType.getPrecision()];
            LongRange range = LongRange.of(genericRange, factor, 0L, 86400000000000000L);
            return blockBuilder -> timeType.writeLong(blockBuilder, this.numberBetween(range.low, range.high) * factor);
        }
        if (type instanceof TimeWithTimeZoneType) {
            TimeWithTimeZoneType timeWithTimeZoneType = (TimeWithTimeZoneType)type;
            return this.timeWithTimeZoneGenerator(genericRange, timeWithTimeZoneType);
        }
        if (type instanceof VarbinaryType) {
            VarbinaryType varType = (VarbinaryType)type;
            if (!genericRange.isAll()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Predicates for varbinary columns are not supported");
            }
            return blockBuilder -> varType.writeSlice(blockBuilder, this.sentenceGenerator.get());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (!genericRange.isAll()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Predicates for varchar columns are not supported");
            }
            if (varcharType.getLength().isPresent()) {
                int length = (Integer)varcharType.getLength().get();
                return blockBuilder -> varcharType.writeSlice(blockBuilder, this.boundedSentenceGenerator.get(this.random.nextInt(length)));
            }
            return blockBuilder -> varcharType.writeSlice(blockBuilder, this.sentenceGenerator.get());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            if (!genericRange.isAll()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Predicates for char columns are not supported");
            }
            return blockBuilder -> charType.writeSlice(blockBuilder, this.boundedSentenceGenerator.get(charType.getLength()));
        }
        if (type instanceof IpAddressType) {
            return this.generateIpV4(genericRange);
        }
        if (type instanceof UuidType) {
            return this.generateUUID(genericRange);
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
    }

    private ObjectWriter objectWriter(Type type) {
        if (BigintType.BIGINT.equals((Object)type)) {
            return (blockBuilder, value) -> BigintType.BIGINT.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return (blockBuilder, value) -> IntegerType.INTEGER.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return (blockBuilder, value) -> SmallintType.SMALLINT.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return (blockBuilder, value) -> TinyintType.TINYINT.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return (blockBuilder, value) -> BooleanType.BOOLEAN.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        }
        if (DateType.DATE.equals((Object)type)) {
            return (blockBuilder, value) -> DateType.DATE.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return (blockBuilder, value) -> decimalType.writeLong(blockBuilder, ((Long)value).longValue());
            }
            return (arg_0, arg_1) -> ((DecimalType)decimalType).writeObject(arg_0, arg_1);
        }
        if (RealType.REAL.equals((Object)type)) {
            return (blockBuilder, value) -> RealType.REAL.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return (blockBuilder, value) -> DoubleType.DOUBLE.writeDouble(blockBuilder, ((Double)value).doubleValue());
        }
        if (IntervalDayTimeType.INTERVAL_DAY_TIME.equals((Object)type)) {
            return (blockBuilder, value) -> IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (IntervalYearMonthType.INTERVAL_YEAR_MONTH.equals((Object)type)) {
            return (blockBuilder, value) -> IntervalYearMonthType.INTERVAL_YEAR_MONTH.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (type instanceof TimestampType) {
            TimestampType tzType = (TimestampType)type;
            if (tzType.isShort()) {
                return (blockBuilder, value) -> tzType.writeLong(blockBuilder, ((Long)value).longValue());
            }
            return (arg_0, arg_1) -> ((TimestampType)tzType).writeObject(arg_0, arg_1);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType tzType = (TimestampWithTimeZoneType)type;
            if (tzType.isShort()) {
                return (blockBuilder, value) -> tzType.writeLong(blockBuilder, ((Long)value).longValue());
            }
            return (arg_0, arg_1) -> ((TimestampWithTimeZoneType)tzType).writeObject(arg_0, arg_1);
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            return (blockBuilder, value) -> timeType.writeLong(blockBuilder, ((Long)value).longValue());
        }
        if (type instanceof TimeWithTimeZoneType) {
            TimeWithTimeZoneType tzType = (TimeWithTimeZoneType)type;
            if (tzType.isShort()) {
                return (blockBuilder, value) -> tzType.writeLong(blockBuilder, ((Long)value).longValue());
            }
            return (arg_0, arg_1) -> ((TimeWithTimeZoneType)tzType).writeObject(arg_0, arg_1);
        }
        if (type instanceof VarbinaryType) {
            VarbinaryType varType = (VarbinaryType)type;
            return (blockBuilder, value) -> varType.writeSlice(blockBuilder, (Slice)value);
        }
        if (type instanceof VarcharType) {
            VarcharType varType = (VarcharType)type;
            return (blockBuilder, value) -> varType.writeSlice(blockBuilder, (Slice)value);
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return (blockBuilder, value) -> charType.writeSlice(blockBuilder, (Slice)value);
        }
        if (type instanceof IpAddressType) {
            return (blockBuilder, value) -> IpAddressType.IPADDRESS.writeSlice(blockBuilder, (Slice)value);
        }
        if (type instanceof UuidType) {
            return (blockBuilder, value) -> UuidType.UUID.writeSlice(blockBuilder, (Slice)value);
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
    }

    private Generator decimalGenerator(Range genericRange, DecimalType decimalType) {
        if (decimalType.isShort()) {
            ShortDecimalRange range = ShortDecimalRange.of(genericRange, decimalType.getPrecision());
            return blockBuilder -> decimalType.writeLong(blockBuilder, this.numberBetween(range.low, range.high));
        }
        Int128Range range = Int128Range.of(genericRange);
        BigInteger currentRange = BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger desiredRange = range.high.toBigInteger().subtract(range.low.toBigInteger());
        return blockBuilder -> decimalType.writeObject(blockBuilder, (Object)Int128.valueOf((BigInteger)new BigInteger(63, this.random).multiply(desiredRange).divide(currentRange).add(range.low.toBigInteger())));
    }

    private Generator timestampGenerator(Range genericRange, TimestampType tzType) {
        if (tzType.isShort()) {
            long factor = POWERS_OF_TEN[6 - tzType.getPrecision()];
            LongRange range = LongRange.of(genericRange, factor);
            return blockBuilder -> tzType.writeLong(blockBuilder, this.numberBetween(range.low, range.high) * factor);
        }
        LongTimestampRange range = LongTimestampRange.of(genericRange, tzType.getPrecision());
        if (tzType.getPrecision() <= 6) {
            return blockBuilder -> {
                long epochMicros = this.numberBetween(range.low.getEpochMicros(), range.high.getEpochMicros());
                tzType.writeObject(blockBuilder, (Object)new LongTimestamp(epochMicros * (long)range.factor, 0));
            };
        }
        return blockBuilder -> {
            long epochMicros = this.numberBetween(range.low.getEpochMicros(), range.high.getEpochMicros());
            int picosOfMicro = epochMicros == range.low.getEpochMicros() ? this.numberBetween(range.low.getPicosOfMicro(), range.low.getEpochMicros() == range.high.getEpochMicros() ? range.high.getPicosOfMicro() : (int)POWERS_OF_TEN[tzType.getPrecision() - 6] - 1) : (epochMicros == range.high.getEpochMicros() ? this.numberBetween(0, range.high.getPicosOfMicro()) : this.numberBetween(0, (int)POWERS_OF_TEN[tzType.getPrecision() - 6] - 1));
            tzType.writeObject(blockBuilder, (Object)new LongTimestamp(epochMicros, picosOfMicro * range.factor));
        };
    }

    private Generator timestampWithTimeZoneGenerator(Range genericRange, TimestampWithTimeZoneType tzType) {
        if (tzType.isShort()) {
            ShortTimestampWithTimeZoneRange range = ShortTimestampWithTimeZoneRange.of(genericRange, tzType.getPrecision());
            return blockBuilder -> {
                long millis = this.numberBetween(range.low, range.high) * range.factor;
                tzType.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)range.defaultTZ));
            };
        }
        LongTimestampWithTimeZoneRange range = LongTimestampWithTimeZoneRange.of(genericRange, tzType.getPrecision());
        int picosOfMilliHigh = (int)POWERS_OF_TEN[tzType.getPrecision() - 3] - 1;
        return blockBuilder -> {
            long millis = this.numberBetween(range.low.getEpochMillis(), range.high.getEpochMillis());
            int picosOfMilli = millis == range.low.getEpochMillis() ? this.numberBetween(range.low.getPicosOfMilli(), range.low.getEpochMillis() == range.high.getEpochMillis() ? range.high.getPicosOfMilli() : picosOfMilliHigh) : (millis == range.high.getEpochMillis() ? this.numberBetween(0, range.high.getPicosOfMilli()) : this.numberBetween(0, picosOfMilliHigh));
            tzType.writeObject(blockBuilder, (Object)LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)millis, (int)(picosOfMilli * range.factor), (short)range.defaultTZ));
        };
    }

    private Generator timeWithTimeZoneGenerator(Range genericRange, TimeWithTimeZoneType timeType) {
        if (timeType.isShort()) {
            ShortTimeWithTimeZoneRange range = ShortTimeWithTimeZoneRange.of(genericRange, timeType.getPrecision());
            return blockBuilder -> {
                long nanos = this.numberBetween(range.low, range.high) * range.factor;
                timeType.writeLong(blockBuilder, DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)range.offsetMinutes));
            };
        }
        LongTimeWithTimeZoneRange range = LongTimeWithTimeZoneRange.of(genericRange, timeType.getPrecision());
        return blockBuilder -> {
            long picoseconds = this.numberBetween(range.low, range.high) * (long)range.factor;
            timeType.writeObject(blockBuilder, (Object)new LongTimeWithTimeZone(picoseconds, range.offsetMinutes));
        };
    }

    private static Int128 add(Int128 left, Int128 right) {
        long[] result = new long[2];
        Int128Math.add((long)left.getHigh(), (long)left.getLow(), (long)right.getHigh(), (long)right.getLow(), (long[])result, (int)0);
        return Int128.valueOf((long[])result);
    }

    private int numberBetween(int min, int max) {
        if (min == max) {
            return min;
        }
        int realMin = Math.min(min, max);
        int realMax = Math.max(min, max);
        int amplitude = realMax - realMin;
        if (amplitude >= 0) {
            return this.random.nextInt(amplitude) + realMin;
        }
        return (int)this.numberBetween((long)realMin, (long)realMax);
    }

    private long numberBetween(long min, long max) {
        if (min == max) {
            return min;
        }
        long realMin = Math.min(min, max);
        long realMax = Math.max(min, max);
        long amplitude = realMax - realMin;
        if (amplitude >= 0L) {
            return this.random.nextLong(amplitude) + realMin;
        }
        BigDecimal bigMin = BigDecimal.valueOf(min);
        BigDecimal bigMax = BigDecimal.valueOf(max);
        BigDecimal randomValue = BigDecimal.valueOf(this.random.nextDouble());
        return bigMin.add(bigMax.subtract(bigMin).multiply(randomValue)).longValue();
    }

    private Generator generateIpV4(Range range) {
        if (!range.isAll()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Predicates for ipaddress columns are not supported");
        }
        return blockBuilder -> {
            byte[] address;
            try {
                address = Inet4Address.getByAddress(new byte[]{(byte)(this.random.nextInt(254) + 2), (byte)(this.random.nextInt(254) + 2), (byte)(this.random.nextInt(254) + 2), (byte)(this.random.nextInt(254) + 2)}).getAddress();
            }
            catch (UnknownHostException e) {
                blockBuilder.appendNull();
                return;
            }
            byte[] bytes = new byte[16];
            bytes[10] = -1;
            bytes[11] = -1;
            System.arraycopy(address, 0, bytes, 12, 4);
            IpAddressType.IPADDRESS.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])bytes, (int)0, (int)16));
        };
    }

    private Generator generateUUID(Range range) {
        if (!range.isAll()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Predicates for uuid columns are not supported");
        }
        return blockBuilder -> {
            UUID uuid = UUID.randomUUID();
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            UuidType.UUID.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])bb.array(), (int)0, (int)16));
        };
    }

    @FunctionalInterface
    private static interface SentenceGenerator {
        public Slice get();
    }

    @FunctionalInterface
    private static interface BoundedSentenceGenerator {
        public Slice get(int var1);
    }

    @FunctionalInterface
    private static interface ObjectWriter {
        public void accept(BlockBuilder var1, Object var2);
    }

    @FunctionalInterface
    private static interface Generator {
        public void accept(BlockBuilder var1);
    }

    @FunctionalInterface
    private static interface SequenceWriter {
        public void accept(BlockBuilder var1, long var2);
    }

    private record LongRange(long low, long high, long step) {
        static LongRange of(Range range) {
            return LongRange.of(range, 1L, Long.MIN_VALUE, Long.MAX_VALUE, 1L);
        }

        static LongRange of(Range range, long factor) {
            return LongRange.of(range, factor, Long.MIN_VALUE, Long.MAX_VALUE, 1L);
        }

        static LongRange of(Range range, long factor, long step) {
            return LongRange.of(range, factor, Long.MIN_VALUE, Long.MAX_VALUE, step);
        }

        static LongRange of(Range range, long factor, long defaultMin, long defaultMax) {
            return LongRange.of(range, factor, defaultMin, defaultMax, 1L);
        }

        static LongRange of(Range range, long factor, long defaultMin, long defaultMax, long step) {
            return new LongRange(Timestamps.roundDiv((long)range.getLowValue().orElse(defaultMin), (long)factor) + (long)(!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0), Timestamps.roundDiv((long)range.getHighValue().orElse(defaultMax), (long)factor) + (long)(!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0), step);
        }

        long at(long index) {
            return Math.min(this.low + index * this.step, this.high - 1L);
        }

        long at(long index, long factor) {
            return Math.min(this.low + Timestamps.roundDiv((long)(index * this.step), (long)factor), this.high - 1L);
        }
    }

    private record IntRange(int low, int high, long step) {
        static IntRange of(Range range) {
            return IntRange.of(range, Integer.MIN_VALUE, Integer.MAX_VALUE, 1L);
        }

        static IntRange of(Range range, long step) {
            return IntRange.of(range, Integer.MIN_VALUE, Integer.MAX_VALUE, step);
        }

        static IntRange of(Range range, long defaultMin, long defaultMax) {
            return IntRange.of(range, defaultMin, defaultMax, 1L);
        }

        static IntRange of(Range range, long defaultMin, long defaultMax, long step) {
            return new IntRange(Math.toIntExact(range.getLowValue().orElse(defaultMin)) + (!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0), Math.toIntExact(range.getHighValue().orElse(defaultMax)) + (!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0), step);
        }

        long at(long index) {
            return Math.min((long)this.low + index * this.step, (long)(this.high - 1));
        }

        long at(long index, long factor) {
            return Math.min((long)this.low + Timestamps.roundDiv((long)(index * this.step), (long)factor), (long)(this.high - 1));
        }
    }

    private record ShortDecimalRange(long low, long high, long step) {
        static ShortDecimalRange of(Range range, int precision) {
            return ShortDecimalRange.of(range, precision, 1L);
        }

        static ShortDecimalRange of(Range range, int precision, long step) {
            long defaultMin = -999999999999999999L / POWERS_OF_TEN[18 - precision];
            long defaultMax = 999999999999999999L / POWERS_OF_TEN[18 - precision];
            long low = range.getLowValue().orElse(defaultMin) + (long)(!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0);
            long high = range.getHighValue().orElse(defaultMax) + (long)(!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0);
            return new ShortDecimalRange(low, high, step);
        }

        long at(long index) {
            return Math.min(this.low + index * this.step, this.high - 1L);
        }
    }

    private record Int128Range(Int128 low, Int128 high, Int128 step) {
        static Int128Range of(Range range) {
            return Int128Range.of(range, Int128.ONE);
        }

        static Int128Range of(Range range, Int128 step) {
            Int128 low = range.getLowValue().orElse(Decimals.MIN_UNSCALED_DECIMAL);
            Int128 high = range.getHighValue().orElse(Decimals.MAX_UNSCALED_DECIMAL);
            if (!range.isLowUnbounded() && !range.isLowInclusive()) {
                low = FakerPageSource.add(low, Int128.ONE);
            }
            if (!range.isHighUnbounded() && range.isHighInclusive()) {
                high = FakerPageSource.add(high, Int128.ONE);
            }
            return new Int128Range(low, high, step);
        }

        Int128 at(long index) {
            Int128 nextValue = FakerPageSource.add(this.low, Int128Math.multiply((Int128)Int128.valueOf((long)index), (Int128)this.step));
            Int128 highInclusive = Int128Math.subtract((Int128)this.high, (Int128)Int128.ONE);
            return highInclusive.compareTo(nextValue) < 0 ? highInclusive : nextValue;
        }
    }

    private record FloatRange(float low, float high, float step) {
        static FloatRange of(Range range) {
            return FloatRange.of(range, 1.0f);
        }

        static FloatRange of(Range range, float step) {
            float low = range.getLowValue().map(v -> Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)v)))).orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
            if (!range.isLowUnbounded() && !range.isLowInclusive()) {
                low = Math.nextUp(low);
            }
            float high = range.getHighValue().map(v -> Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)v)))).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
            if (!range.isHighUnbounded() && range.isHighInclusive()) {
                high = Math.nextUp(high);
            }
            return new FloatRange(low, high, step);
        }

        float at(long index) {
            return Math.min(this.low + (float)index * this.step, Math.nextDown(this.high));
        }
    }

    private record DoubleRange(double low, double high, double step) {
        static DoubleRange of(Range range) {
            return DoubleRange.of(range, 1.0);
        }

        static DoubleRange of(Range range, double step) {
            double low = range.getLowValue().orElse(Double.MIN_VALUE);
            if (!range.isLowUnbounded() && !range.isLowInclusive()) {
                low = Math.nextUp(low);
            }
            double high = range.getHighValue().orElse(Double.MAX_VALUE);
            if (!range.isHighUnbounded() && range.isHighInclusive()) {
                high = Math.nextUp(high);
            }
            return new DoubleRange(low, high, step);
        }

        double at(long index) {
            return Math.min(this.low + (double)index * this.step, Math.nextDown(this.high));
        }
    }

    private record LongTimestampRange(LongTimestamp low, LongTimestamp high, int factor, long step) {
        static LongTimestampRange of(Range range, int precision) {
            return LongTimestampRange.of(range, precision, 1L);
        }

        static LongTimestampRange of(Range range, int precision, long step) {
            LongTimestamp low = range.getLowValue().orElse(new LongTimestamp(Long.MIN_VALUE, 0));
            LongTimestamp high = range.getHighValue().orElse(new LongTimestamp(Long.MAX_VALUE, 999999));
            if (precision <= 6) {
                int factor = (int)POWERS_OF_TEN[6 - precision];
                low = new LongTimestamp(Timestamps.roundDiv((long)low.getEpochMicros(), (long)factor) + (long)(!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0), 0);
                high = new LongTimestamp(Timestamps.roundDiv((long)high.getEpochMicros(), (long)factor) + (long)(!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0), 0);
                return new LongTimestampRange(low, high, factor, step);
            }
            int factor = (int)POWERS_OF_TEN[12 - precision];
            int lowPicosOfMicro = Timestamps.roundDiv((int)low.getPicosOfMicro(), (long)factor) + (!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0);
            low = new LongTimestamp(low.getEpochMicros() - (long)(lowPicosOfMicro < 0 ? 1 : 0), (lowPicosOfMicro + factor) % factor);
            int highPicosOfMicro = Timestamps.roundDiv((int)high.getPicosOfMicro(), (long)factor) + (!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0);
            high = new LongTimestamp(high.getEpochMicros() + (long)(highPicosOfMicro > factor ? 1 : 0), highPicosOfMicro % factor);
            return new LongTimestampRange(low, high, factor, step);
        }

        LongTimestamp at(long index, long stepFactor) {
            long epochMicros = this.low.getEpochMicros() + Timestamps.roundDiv((long)(index * this.step), (long)stepFactor);
            return new LongTimestamp(this.step > 0L ? Math.min(epochMicros, this.high.getEpochMicros()) : Math.max(epochMicros, this.high.getEpochMicros()), 0);
        }
    }

    private record ShortTimestampWithTimeZoneRange(long low, long high, long factor, TimeZoneKey defaultTZ, long step) {
        static ShortTimestampWithTimeZoneRange of(Range range, int precision) {
            return ShortTimestampWithTimeZoneRange.of(range, precision, 1L);
        }

        static ShortTimestampWithTimeZoneRange of(Range range, int precision, long step) {
            TimeZoneKey defaultTZ = range.getLowValue().map(v -> DateTimeEncoding.unpackZoneKey((long)((Long)v))).orElse(range.getHighValue().map(v -> DateTimeEncoding.unpackZoneKey((long)((Long)v))).orElse(TimeZoneKey.UTC_KEY));
            long factor = POWERS_OF_TEN[3 - precision];
            long low = Timestamps.roundDiv((long)DateTimeEncoding.unpackMillisUtc((long)range.getLowValue().orElse(Long.MIN_VALUE)), (long)factor) + (long)(!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0);
            long high = Timestamps.roundDiv((long)DateTimeEncoding.unpackMillisUtc((long)range.getHighValue().orElse(Long.MAX_VALUE)), (long)factor) + (long)(!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0);
            return new ShortTimestampWithTimeZoneRange(low, high, factor, defaultTZ, step);
        }

        long at(long index, long stepFactor) {
            long millis = this.low + Timestamps.roundDiv((long)(index * this.step), (long)(this.factor * stepFactor));
            return DateTimeEncoding.packDateTimeWithZone((long)((this.step > 0L ? Math.min(millis, this.high - 1L) : Math.max(millis, this.high - 1L)) * this.factor), (TimeZoneKey)this.defaultTZ);
        }
    }

    private record LongTimestampWithTimeZoneRange(LongTimestampWithTimeZone low, LongTimestampWithTimeZone high, int factor, short defaultTZ, long step) {
        static LongTimestampWithTimeZoneRange of(Range range, int precision) {
            return LongTimestampWithTimeZoneRange.of(range, precision, 1L);
        }

        static LongTimestampWithTimeZoneRange of(Range range, int precision, long step) {
            short defaultTZ = range.getLowValue().map(v -> ((LongTimestampWithTimeZone)v).getTimeZoneKey()).orElse(range.getHighValue().map(v -> ((LongTimestampWithTimeZone)v).getTimeZoneKey()).orElse(TimeZoneKey.UTC_KEY.getKey()));
            LongTimestampWithTimeZone low = range.getLowValue().orElse(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)-2251799813685248L, (int)0, (short)defaultTZ));
            LongTimestampWithTimeZone high = range.getHighValue().orElse(LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)0x7FFFFFFFFFFFFL, (int)999999999, (short)defaultTZ));
            if (low.getTimeZoneKey() != high.getTimeZoneKey()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Range boundaries for timestamp with time zone columns must have the same time zone");
            }
            int factor = (int)POWERS_OF_TEN[12 - precision];
            int lowPicosOfMilli = Timestamps.roundDiv((int)low.getPicosOfMilli(), (long)factor) + (!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0);
            low = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(low.getEpochMillis() - (long)(lowPicosOfMilli < 0 ? 1 : 0)), (int)((lowPicosOfMilli + factor) % factor), (short)low.getTimeZoneKey());
            int highPicosOfMilli = Timestamps.roundDiv((int)high.getPicosOfMilli(), (long)factor) + (!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0);
            high = LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(high.getEpochMillis() + (long)(highPicosOfMilli > factor ? 1 : 0)), (int)(highPicosOfMilli % factor), (short)high.getTimeZoneKey());
            return new LongTimestampWithTimeZoneRange(low, high, factor, defaultTZ, step);
        }

        LongTimestampWithTimeZone at(long index, long stepFactor) {
            long millis = this.low.getEpochMillis() + Timestamps.roundDiv((long)(index * this.step), (long)stepFactor);
            return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(this.step > 0L ? Math.min(millis, this.high.getEpochMillis()) : Math.max(millis, this.high.getEpochMillis())), (int)0, (short)this.defaultTZ);
        }
    }

    private record ShortTimeWithTimeZoneRange(long low, long high, long factor, int offsetMinutes, long step) {
        static ShortTimeWithTimeZoneRange of(Range range, int precision) {
            return ShortTimeWithTimeZoneRange.of(range, precision, 1L);
        }

        static ShortTimeWithTimeZoneRange of(Range range, int precision, long step) {
            int offsetMinutes = range.getLowValue().map(v -> DateTimeEncoding.unpackOffsetMinutes((long)((Long)v))).orElse(range.getHighValue().map(v -> DateTimeEncoding.unpackOffsetMinutes((long)((Long)v))).orElse(0));
            long factor = POWERS_OF_TEN[9 - precision];
            long low = Timestamps.roundDiv((long)range.getLowValue().map(v -> DateTimeEncoding.unpackTimeNanos((long)((Long)v))).orElse(0L), (long)factor) + (long)(!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0);
            long high = Timestamps.roundDiv((long)range.getHighValue().map(v -> DateTimeEncoding.unpackTimeNanos((long)((Long)v))).orElse(86400000000000L), (long)factor) + (long)(!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0);
            return new ShortTimeWithTimeZoneRange(low, high, factor, offsetMinutes, step);
        }

        long at(long index) {
            long nanos = this.low + Timestamps.roundDiv((long)(index * this.step), (long)this.factor);
            return DateTimeEncoding.packTimeWithTimeZone((long)((this.step > 0L ? Math.min(nanos, this.high - 1L) : Math.max(nanos, this.high - 1L)) * this.factor), (int)this.offsetMinutes);
        }
    }

    private record LongTimeWithTimeZoneRange(long low, long high, int factor, int offsetMinutes, long step) {
        static LongTimeWithTimeZoneRange of(Range range, int precision) {
            return LongTimeWithTimeZoneRange.of(range, precision, 1L);
        }

        static LongTimeWithTimeZoneRange of(Range range, int precision, long step) {
            int offsetMinutes = range.getLowValue().map(v -> ((LongTimeWithTimeZone)v).getOffsetMinutes()).orElse(range.getHighValue().map(v -> ((LongTimeWithTimeZone)v).getOffsetMinutes()).orElse(0));
            LongTimeWithTimeZone low = range.getLowValue().orElse(new LongTimeWithTimeZone(0L, offsetMinutes));
            LongTimeWithTimeZone high = range.getHighValue().orElse(new LongTimeWithTimeZone(86400000000000000L, offsetMinutes));
            if (low.getOffsetMinutes() != high.getOffsetMinutes()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, "Range boundaries for time with time zone columns must have the same time zone");
            }
            int factor = (int)POWERS_OF_TEN[12 - precision];
            long longLow = Timestamps.roundDiv((long)low.getPicoseconds(), (long)factor) + (long)(!range.isLowUnbounded() && !range.isLowInclusive() ? 1 : 0);
            long longHigh = Timestamps.roundDiv((long)high.getPicoseconds(), (long)factor) + (long)(!range.isHighUnbounded() && range.isHighInclusive() ? 1 : 0);
            return new LongTimeWithTimeZoneRange(longLow, longHigh, factor, offsetMinutes, step);
        }

        LongTimeWithTimeZone at(long index) {
            long picoseconds = this.low + Timestamps.roundDiv((long)(index * this.step), (long)this.factor);
            return new LongTimeWithTimeZone((this.step > 0L ? Math.min(picoseconds, this.high - 1L) : Math.max(picoseconds, this.high - 1L)) * (long)this.factor, this.offsetMinutes);
        }
    }
}

