/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.faker.FakerSplit;
import io.trino.plugin.faker.FakerTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;

public class FakerSplitManager
implements ConnectorSplitManager {
    static final long MAX_ROWS_PER_SPLIT = 1024000L;

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        FakerTableHandle fakerTable = (FakerTableHandle)table;
        ImmutableList.Builder splits = ImmutableList.builder();
        int splitNum = 0;
        long rowsOffset = 0L;
        long remainingRows = fakerTable.limit();
        while (remainingRows > 0L) {
            long splitSize = Math.min(remainingRows, 1024000L);
            splits.add((Object)new FakerSplit(splitNum, rowsOffset, splitSize));
            rowsOffset += splitSize;
            remainingRows -= splitSize;
            ++splitNum;
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

