/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.type.DateTimes;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.IpAddressType;
import io.trino.util.DateTimeUtils;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Literal {
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.whitespace();
    private static final CharMatcher HEX_DIGIT_MATCHER = CharMatcher.inRange((char)'A', (char)'F').or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("([+-]?)(\\d(?:_?\\d)*)?(?:\\.(\\d(?:_?\\d)*)?)?");

    private Literal() {
    }

    public static Object parse(String value, Type type) {
        if (value == null) {
            return null;
        }
        if (BigintType.BIGINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type)) {
            return Literal.parseLong(value);
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return Literal.parseBoolean(value);
        }
        if (DateType.DATE.equals((Object)type)) {
            return (long)DateTimeUtils.parseDate((String)value);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return Literal.parseDecimal(value, decimalType);
        }
        if (RealType.REAL.equals((Object)type)) {
            return (long)Float.floatToRawIntBits(Float.parseFloat(value));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return Double.parseDouble(value);
        }
        if (IntervalDayTimeType.INTERVAL_DAY_TIME.equals((Object)type)) {
            return DateTimeUtils.parseDayTimeInterval((String)value, (IntervalLiteral.IntervalField)IntervalLiteral.IntervalField.SECOND, Optional.empty());
        }
        if (IntervalYearMonthType.INTERVAL_YEAR_MONTH.equals((Object)type)) {
            return DateTimeUtils.parseYearMonthInterval((String)value, (IntervalLiteral.IntervalField)IntervalLiteral.IntervalField.MONTH, Optional.empty());
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            return DateTimes.parseTimestamp((int)timestampType.getPrecision(), (String)value);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            return DateTimes.parseTimestampWithTimeZone((int)timestampWithTimeZoneType.getPrecision(), (String)value);
        }
        if (type instanceof TimeType) {
            return DateTimes.parseTime((String)value);
        }
        if (type instanceof TimeWithTimeZoneType) {
            TimeWithTimeZoneType timeWithTimeZoneType = (TimeWithTimeZoneType)type;
            return DateTimes.parseTimeWithTimeZone((int)timeWithTimeZoneType.getPrecision(), (String)value);
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return Literal.parseBinary(value);
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return Slices.utf8Slice((String)value);
        }
        if (type instanceof IpAddressType) {
            return Literal.parseIpAddress(value);
        }
        if (type instanceof UuidType) {
            return UuidType.javaUuidToTrinoUuid((UUID)UUID.fromString(value));
        }
        throw new IllegalArgumentException("Unsupported literal type: " + String.valueOf(type));
    }

    private static long parseLong(String value) {
        if ((value = value.replace("_", "")).startsWith("0x") || value.startsWith("0X")) {
            return Long.parseLong(value.substring(2), 16);
        }
        if (value.startsWith("0b") || value.startsWith("0B")) {
            return Long.parseLong(value.substring(2), 2);
        }
        if (value.startsWith("0o") || value.startsWith("0O")) {
            return Long.parseLong(value.substring(2), 8);
        }
        return Long.parseLong(value);
    }

    private static Boolean parseBoolean(String value) {
        Preconditions.checkArgument(((value = value.toLowerCase(Locale.ENGLISH)).equals("true") || value.equals("false") ? 1 : 0) != 0);
        return value.equals("true");
    }

    private static Object parseDecimal(String value, DecimalType decimalType) {
        Matcher matcher = DECIMAL_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid DECIMAL value '" + value + "'");
        }
        String sign = Literal.getMatcherGroup(matcher, 1);
        if (sign.isEmpty()) {
            sign = "+";
        }
        String integralPart = Literal.getMatcherGroup(matcher, 2);
        String fractionalPart = Literal.getMatcherGroup(matcher, 3);
        if (integralPart.isEmpty() && fractionalPart.isEmpty()) {
            throw new IllegalArgumentException("Invalid DECIMAL value '" + value + "'");
        }
        integralPart = Literal.stripLeadingZeros(integralPart.replace("_", ""));
        fractionalPart = fractionalPart.replace("_", "");
        String unscaledValue = sign + (integralPart.isEmpty() ? "0" : "") + integralPart + fractionalPart;
        if (decimalType.isShort()) {
            return Long.parseLong(unscaledValue);
        }
        return Int128.valueOf((BigInteger)new BigInteger(unscaledValue));
    }

    private static String getMatcherGroup(MatchResult matcher, int group) {
        String groupValue = matcher.group(group);
        if (groupValue == null) {
            groupValue = "";
        }
        return groupValue;
    }

    private static String stripLeadingZeros(String number) {
        for (int i = 0; i < number.length(); ++i) {
            if (number.charAt(i) == '0') continue;
            return number.substring(i);
        }
        return "";
    }

    private static Slice parseBinary(String value) {
        String hexString = WHITESPACE_MATCHER.removeFrom((CharSequence)value).toUpperCase(Locale.ENGLISH);
        if (!HEX_DIGIT_MATCHER.matchesAllOf((CharSequence)hexString)) {
            throw new IllegalArgumentException("Binary literal can only contain hexadecimal digits");
        }
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("Binary literal must contain an even number of digits");
        }
        return Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)hexString));
    }

    private static Slice parseIpAddress(String value) {
        byte[] bytes;
        byte[] address;
        try {
            address = InetAddresses.forString((String)value).getAddress();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot cast value to IPADDRESS: " + value);
        }
        if (address.length == 4) {
            bytes = new byte[16];
            bytes[10] = -1;
            bytes[11] = -1;
            System.arraycopy(address, 0, bytes, 12, 4);
        } else if (address.length == 16) {
            bytes = address;
        } else {
            throw new IllegalArgumentException("Invalid InetAddress length: " + address.length);
        }
        return Slices.wrappedBuffer((byte[])bytes);
    }
}

