/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.faker;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.faker.ColumnInfo;
import io.trino.spi.connector.ColumnHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record TableInfo(List<ColumnInfo> columns, Map<String, Object> properties, Optional<String> comment) {
    public static final String NULL_PROBABILITY_PROPERTY = "null_probability";
    public static final String DEFAULT_LIMIT_PROPERTY = "default_limit";

    public TableInfo {
        columns = ImmutableList.copyOf(columns);
        properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        Objects.requireNonNull(comment, "comment is null");
    }

    public ColumnInfo column(ColumnHandle handle) {
        return this.columns.stream().filter(column -> column.handle().equals(handle)).findFirst().orElseThrow();
    }

    public TableInfo withColumns(List<ColumnInfo> columns) {
        return new TableInfo(columns, this.properties, this.comment);
    }

    public TableInfo withProperties(Map<String, Object> properties) {
        return new TableInfo(this.columns, properties, this.comment);
    }

    public TableInfo withComment(Optional<String> comment) {
        return new TableInfo(this.columns, this.properties, comment);
    }
}

