/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.checkpoint;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.orc.checkpoint.Checkpoints;
import java.util.List;

public final class InputStreamCheckpoint {
    private InputStreamCheckpoint() {
    }

    public static long createInputStreamCheckpoint(boolean compressed, Checkpoints.ColumnPositionsList positionsList) {
        if (compressed) {
            return InputStreamCheckpoint.createInputStreamCheckpoint(positionsList.nextPosition(), positionsList.nextPosition());
        }
        return InputStreamCheckpoint.createInputStreamCheckpoint(0, positionsList.nextPosition());
    }

    public static long createInputStreamCheckpoint(int compressedBlockOffset, int decompressedOffset) {
        return (long)compressedBlockOffset << 32 | (long)decompressedOffset;
    }

    public static int decodeCompressedBlockOffset(long inputStreamCheckpoint) {
        return (int)(inputStreamCheckpoint >> 32);
    }

    public static int decodeDecompressedOffset(long inputStreamCheckpoint) {
        return (int)inputStreamCheckpoint;
    }

    public static List<Integer> createInputStreamPositionList(boolean compressed, long inputStreamCheckpoint) {
        if (compressed) {
            return ImmutableList.of((Object)InputStreamCheckpoint.decodeCompressedBlockOffset(inputStreamCheckpoint), (Object)InputStreamCheckpoint.decodeDecompressedOffset(inputStreamCheckpoint));
        }
        return ImmutableList.of((Object)InputStreamCheckpoint.decodeDecompressedOffset(inputStreamCheckpoint));
    }

    public static String inputStreamCheckpointToString(long inputStreamCheckpoint) {
        return MoreObjects.toStringHelper(InputStreamCheckpoint.class).add("decompressedOffset", InputStreamCheckpoint.decodeDecompressedOffset(inputStreamCheckpoint)).add("compressedBlockOffset", InputStreamCheckpoint.decodeCompressedBlockOffset(inputStreamCheckpoint)).toString();
    }
}

