/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.configuration.secrets.SecretsResolver;
import io.airlift.log.Logger;
import io.trino.connector.CatalogStoreConfig;
import io.trino.connector.FileCatalogStoreFactory;
import io.trino.connector.InMemoryCatalogStoreFactory;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.catalog.CatalogStore;
import io.trino.spi.catalog.CatalogStoreFactory;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorName;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class CatalogStoreManager
implements CatalogStore {
    private static final Logger log = Logger.get(CatalogStoreManager.class);
    private static final File CATALOG_STORE_CONFIGURATION = new File("etc/catalog-store.properties");
    private final Map<String, CatalogStoreFactory> catalogStoreFactories = new ConcurrentHashMap<String, CatalogStoreFactory>();
    private final AtomicReference<Optional<CatalogStore>> configuredCatalogStore = new AtomicReference(Optional.empty());
    private final SecretsResolver secretsResolver;
    private final String catalogStoreKind;

    @Inject
    public CatalogStoreManager(SecretsResolver secretsResolver, CatalogStoreConfig catalogStoreConfig) {
        this.secretsResolver = Objects.requireNonNull(secretsResolver, "secretsResolver is null");
        this.catalogStoreKind = Objects.requireNonNull(catalogStoreConfig.getCatalogStoreKind(), "catalogStoreKind is null");
        this.addCatalogStoreFactory(new InMemoryCatalogStoreFactory());
        this.addCatalogStoreFactory(new FileCatalogStoreFactory());
    }

    public void addCatalogStoreFactory(CatalogStoreFactory catalogStoreFactory) {
        Objects.requireNonNull(catalogStoreFactory, "catalogStoreFactory is null");
        if (this.catalogStoreFactories.putIfAbsent(catalogStoreFactory.getName(), catalogStoreFactory) != null) {
            throw new IllegalArgumentException("Catalog store factory '%s' is already registered".formatted(catalogStoreFactory.getName()));
        }
    }

    public void loadConfiguredCatalogStore() {
        this.loadConfiguredCatalogStore(this.catalogStoreKind, CATALOG_STORE_CONFIGURATION);
    }

    @VisibleForTesting
    void loadConfiguredCatalogStore(String catalogStoreName, File catalogStoreFile) {
        if (this.configuredCatalogStore.get().isPresent()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (catalogStoreFile.exists()) {
            try {
                properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)catalogStoreFile.getPath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read configuration file: " + String.valueOf(catalogStoreFile), e);
            }
        }
        this.setConfiguredCatalogStore(catalogStoreName, properties);
    }

    @VisibleForTesting
    protected void setConfiguredCatalogStore(String name, Map<String, String> properties) {
        CatalogStore catalogStore;
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading catalog store %s --", new Object[]{name});
        CatalogStoreFactory factory = this.catalogStoreFactories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Catalog store %s is not registered", (Object)name);
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            catalogStore = factory.create((Map)ImmutableMap.copyOf((Map)this.secretsResolver.getResolvedConfiguration(properties)));
        }
        this.setConfiguredCatalogStore(catalogStore);
        log.info("-- Loaded catalog store %s --", new Object[]{name});
    }

    @VisibleForTesting
    protected void setConfiguredCatalogStore(CatalogStore catalogStore) {
        Preconditions.checkState((boolean)this.configuredCatalogStore.compareAndSet(Optional.empty(), Optional.of(catalogStore)), (Object)"catalogStore is already set");
    }

    public Collection<CatalogStore.StoredCatalog> getCatalogs() {
        return this.getCatalogStore().getCatalogs();
    }

    public CatalogProperties createCatalogProperties(CatalogName catalogName, ConnectorName connectorName, Map<String, String> properties) {
        return this.getCatalogStore().createCatalogProperties(catalogName, connectorName, properties);
    }

    public void addOrReplaceCatalog(CatalogProperties catalogProperties) {
        this.getCatalogStore().addOrReplaceCatalog(catalogProperties);
    }

    public void removeCatalog(CatalogName catalogName) {
        this.getCatalogStore().removeCatalog(catalogName);
    }

    @VisibleForTesting
    public CatalogStore getCatalogStore() {
        return this.configuredCatalogStore.get().orElseThrow(() -> new IllegalStateException("Catalog store is not configured"));
    }
}

