/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableMap;
import io.trino.cost.AggregationStatsRule;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SimpleStatsRule;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Map;
import java.util.Optional;

public class DistinctLimitStatsRule
extends SimpleStatsRule<DistinctLimitNode> {
    private static final Pattern<DistinctLimitNode> PATTERN = Patterns.distinctLimit();

    public DistinctLimitStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<DistinctLimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(DistinctLimitNode node, StatsCalculator.Context context) {
        if (node.isPartial()) {
            return Optional.empty();
        }
        PlanNodeStatsEstimate distinctStats = AggregationStatsRule.groupBy(context.statsProvider().getStats(node.getSource()), node.getDistinctSymbols(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of());
        PlanNodeStatsEstimate distinctLimitStats = distinctStats.mapOutputRowCount(rowCount -> Math.min(rowCount, (double)node.getLimit()));
        return Optional.of(distinctLimitStats);
    }
}

