/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.warnings;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.execution.warnings.WarningCollector;
import io.trino.execution.warnings.WarningCollectorConfig;
import io.trino.spi.TrinoWarning;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@ThreadSafe
public class DefaultWarningCollector
implements WarningCollector {
    @GuardedBy(value="this")
    private final Set<TrinoWarning> warnings = new LinkedHashSet<TrinoWarning>();
    private final int maxWarnings;

    public DefaultWarningCollector(WarningCollectorConfig config) {
        this.maxWarnings = Objects.requireNonNull(config, "config is null").getMaxWarnings();
    }

    @Override
    public synchronized void add(TrinoWarning warning) {
        Objects.requireNonNull(warning, "warning is null");
        if (this.warnings.size() < this.maxWarnings) {
            this.warnings.add(warning);
        }
    }

    @Override
    public synchronized List<TrinoWarning> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }
}

