/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.inject.BindingAnnotation;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.memory.KillTarget;
import io.trino.memory.MemoryInfo;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface LowMemoryKiller {
    public Optional<KillTarget> chooseTargetToKill(List<RunningQueryInfo> var1, List<MemoryInfo> var2);

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForTaskLowMemoryKiller {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForQueryLowMemoryKiller {
    }

    public static class RunningQueryInfo {
        private final QueryId queryId;
        private final long memoryReservation;
        private final Map<TaskId, TaskInfo> taskInfos;
        private final RetryPolicy retryPolicy;

        public RunningQueryInfo(QueryId queryId, long memoryReservation, Map<TaskId, TaskInfo> taskInfos, RetryPolicy retryPolicy) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.memoryReservation = memoryReservation;
            Objects.requireNonNull(taskInfos, "taskInfos is null");
            this.taskInfos = ImmutableMap.copyOf(taskInfos);
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public long getMemoryReservation() {
            return this.memoryReservation;
        }

        public Map<TaskId, TaskInfo> getTaskInfos() {
            return this.taskInfos;
        }

        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("memoryReservation", this.memoryReservation).add("taskStats", this.taskInfos).add("retryPolicy", (Object)this.retryPolicy).toString();
        }
    }
}

