/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableSet;
import io.trino.metadata.InternalNode;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class AllNodes {
    private final Set<InternalNode> activeNodes;
    private final Set<InternalNode> inactiveNodes;
    private final Set<InternalNode> drainingNodes;
    private final Set<InternalNode> drainedNodes;
    private final Set<InternalNode> shuttingDownNodes;
    private final Set<InternalNode> activeCoordinators;

    public AllNodes(Set<InternalNode> activeNodes, Set<InternalNode> inactiveNodes, Set<InternalNode> drainingNodes, Set<InternalNode> drainedNodes, Set<InternalNode> shuttingDownNodes, Set<InternalNode> activeCoordinators) {
        this.activeNodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(activeNodes, "activeNodes is null"));
        this.inactiveNodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(inactiveNodes, "inactiveNodes is null"));
        this.drainedNodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(drainedNodes, "drainedNodes is null"));
        this.drainingNodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(drainingNodes, "drainingNodes is null"));
        this.shuttingDownNodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(shuttingDownNodes, "shuttingDownNodes is null"));
        this.activeCoordinators = ImmutableSet.copyOf((Collection)Objects.requireNonNull(activeCoordinators, "activeCoordinators is null"));
    }

    public Set<InternalNode> getActiveNodes() {
        return this.activeNodes;
    }

    public Set<InternalNode> getInactiveNodes() {
        return this.inactiveNodes;
    }

    public Set<InternalNode> getShuttingDownNodes() {
        return this.shuttingDownNodes;
    }

    public Set<InternalNode> getDrainedNodes() {
        return this.drainedNodes;
    }

    public Set<InternalNode> getDrainingNodes() {
        return this.drainingNodes;
    }

    public Set<InternalNode> getActiveCoordinators() {
        return this.activeCoordinators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllNodes allNodes = (AllNodes)o;
        return Objects.equals(this.activeNodes, allNodes.activeNodes) && Objects.equals(this.inactiveNodes, allNodes.inactiveNodes) && Objects.equals(this.drainedNodes, allNodes.drainedNodes) && Objects.equals(this.drainingNodes, allNodes.drainingNodes) && Objects.equals(this.shuttingDownNodes, allNodes.shuttingDownNodes) && Objects.equals(this.activeCoordinators, allNodes.activeCoordinators);
    }

    public int hashCode() {
        return Objects.hash(this.activeNodes, this.inactiveNodes, this.drainingNodes, this.drainedNodes, this.shuttingDownNodes, this.activeCoordinators);
    }
}

