/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.inject.Inject;
import io.trino.FeaturesConfig;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.P4HyperLogLogType;
import io.trino.spi.type.ParametricType;
import io.trino.spi.type.QuantileDigestParametricType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeParametricType;
import io.trino.spi.type.TimeWithTimeZoneParametricType;
import io.trino.spi.type.TimestampParametricType;
import io.trino.spi.type.TimestampWithTimeZoneParametricType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeParameter;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.type.ArrayParametricType;
import io.trino.type.CharParametricType;
import io.trino.type.CodePointsType;
import io.trino.type.ColorType;
import io.trino.type.DecimalParametricType;
import io.trino.type.FunctionParametricType;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.IpAddressType;
import io.trino.type.JoniRegexpType;
import io.trino.type.Json2016Type;
import io.trino.type.JsonPathType;
import io.trino.type.JsonType;
import io.trino.type.LikePatternType;
import io.trino.type.MapParametricType;
import io.trino.type.Re2JRegexpType;
import io.trino.type.RowParametricType;
import io.trino.type.TDigestType;
import io.trino.type.UnknownType;
import io.trino.type.VarcharParametricType;
import io.trino.type.setdigest.SetDigestType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ThreadSafe
public final class TypeRegistry {
    private static final SqlParser SQL_PARSER = new SqlParser();
    private final ConcurrentMap<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();
    private final ConcurrentMap<String, ParametricType> parametricTypes = new ConcurrentHashMap<String, ParametricType>();
    private final NonEvictableCache<TypeSignature, Type> parametricTypeCache;
    private final TypeManager typeManager;
    private final TypeOperators typeOperators;

    @Inject
    public TypeRegistry(TypeOperators typeOperators, FeaturesConfig featuresConfig) {
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.types.put(UnknownType.UNKNOWN.getTypeSignature(), (Type)UnknownType.UNKNOWN);
        this.addType((Type)BooleanType.BOOLEAN);
        this.addType((Type)BigintType.BIGINT);
        this.addType((Type)IntegerType.INTEGER);
        this.addType("int", (Type)IntegerType.INTEGER);
        this.addType((Type)SmallintType.SMALLINT);
        this.addType((Type)TinyintType.TINYINT);
        this.addType((Type)DoubleType.DOUBLE);
        this.addType((Type)RealType.REAL);
        this.addType((Type)VarbinaryType.VARBINARY);
        this.addType((Type)DateType.DATE);
        this.addType((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        this.addType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME);
        this.addType((Type)HyperLogLogType.HYPER_LOG_LOG);
        this.addType((Type)SetDigestType.SET_DIGEST);
        this.addType((Type)P4HyperLogLogType.P4_HYPER_LOG_LOG);
        this.addType((Type)JoniRegexpType.JONI_REGEXP);
        this.addType((Type)new Re2JRegexpType(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries()));
        this.addType((Type)LikePatternType.LIKE_PATTERN);
        this.addType((Type)JsonPathType.JSON_PATH);
        this.addType((Type)Json2016Type.JSON_2016);
        this.addType((Type)ColorType.COLOR);
        this.addType((Type)JsonType.JSON);
        this.addType((Type)CodePointsType.CODE_POINTS);
        this.addType((Type)IpAddressType.IPADDRESS);
        this.addType((Type)UuidType.UUID);
        this.addType((Type)TDigestType.TDIGEST);
        this.addParametricType(VarcharParametricType.VARCHAR);
        this.addParametricType(CharParametricType.CHAR);
        this.addParametricType(DecimalParametricType.DECIMAL);
        this.addParametricType(RowParametricType.ROW);
        this.addParametricType(ArrayParametricType.ARRAY);
        this.addParametricType(MapParametricType.MAP);
        this.addParametricType(FunctionParametricType.FUNCTION);
        this.addParametricType((ParametricType)QuantileDigestParametricType.QDIGEST);
        this.addParametricType((ParametricType)TimestampParametricType.TIMESTAMP);
        this.addParametricType((ParametricType)TimestampWithTimeZoneParametricType.TIMESTAMP_WITH_TIME_ZONE);
        this.addParametricType((ParametricType)TimeParametricType.TIME);
        this.addParametricType((ParametricType)TimeWithTimeZoneParametricType.TIME_WITH_TIME_ZONE);
        this.parametricTypeCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));
        this.typeManager = new InternalTypeManager(this, typeOperators);
        this.verifyTypes();
    }

    public Type getType(TypeSignature signature) {
        Type type = (Type)this.types.get(signature);
        if (type == null) {
            try {
                return (Type)CacheUtils.uncheckedCacheGet(this.parametricTypeCache, (Object)signature, () -> this.instantiateParametricType(signature));
            }
            catch (UncheckedExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
        return type;
    }

    public Type getType(TypeId id) {
        return this.fromSqlType(id.getId());
    }

    public Type fromSqlType(String sqlType) {
        try {
            return this.getType(TypeSignatureTranslator.toTypeSignature(SQL_PARSER.createType(sqlType)));
        }
        catch (ParsingException e) {
            throw new TypeNotFoundException(sqlType, (Throwable)e);
        }
    }

    private Type instantiateParametricType(TypeSignature signature) {
        Type instantiatedType;
        ArrayList<TypeParameter> parameters = new ArrayList<TypeParameter>();
        for (TypeSignatureParameter parameter : signature.getParameters()) {
            TypeParameter typeParameter = TypeParameter.of((TypeSignatureParameter)parameter, (TypeManager)this.typeManager);
            parameters.add(typeParameter);
        }
        ParametricType parametricType = (ParametricType)this.parametricTypes.get(signature.getBase().toLowerCase(Locale.ENGLISH));
        if (parametricType == null) {
            throw new TypeNotFoundException(signature);
        }
        try {
            instantiatedType = parametricType.createType(this.typeManager, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new TypeNotFoundException(signature, (Throwable)e);
        }
        return instantiatedType;
    }

    public Collection<Type> getTypes() {
        return ImmutableList.copyOf(this.types.values());
    }

    public Collection<ParametricType> getParametricTypes() {
        return ImmutableList.copyOf(this.parametricTypes.values());
    }

    public void addType(Type type) {
        Objects.requireNonNull(type, "type is null");
        Type existingType = this.types.putIfAbsent(type.getTypeSignature(), type);
        Preconditions.checkState((existingType == null || existingType.equals((Object)type) ? 1 : 0) != 0, (String)"Type %s is already registered", (Object)type);
    }

    public void addType(String alias, Type type) {
        Objects.requireNonNull(alias, "alias is null");
        Objects.requireNonNull(type, "type is null");
        Type existingType = this.types.putIfAbsent(new TypeSignature(alias, new TypeSignatureParameter[0]), type);
        Preconditions.checkState((existingType == null || existingType.equals((Object)type) ? 1 : 0) != 0, (String)"Alias %s is already mapped to %s", (Object)alias, (Object)type);
    }

    public void addParametricType(ParametricType parametricType) {
        String name = parametricType.getName().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!this.parametricTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type already registered: %s", (Object)name);
        this.parametricTypes.putIfAbsent(name, parametricType);
    }

    public TypeOperators getTypeOperators() {
        return this.typeOperators;
    }

    public void verifyTypes() {
        HashSet<Type> missingOperatorDeclaration = new HashSet<Type>();
        HashMultimap missingOperators = HashMultimap.create();
        for (Type type : ImmutableList.copyOf(this.types.values())) {
            if (type.getTypeOperatorDeclaration(this.typeOperators) == null) {
                missingOperatorDeclaration.add(type);
                continue;
            }
            if (type.isComparable()) {
                if (!this.hasEqualMethod(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.EQUAL);
                }
                if (!this.hasHashCodeMethod(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.HASH_CODE);
                }
                if (!this.hasXxHash64Method(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.XX_HASH_64);
                }
                if (!this.hasIdenticalMethod(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.IDENTICAL);
                }
                if (!this.hasIndeterminateMethod(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.INDETERMINATE);
                }
            }
            if (!type.isOrderable()) continue;
            if (!this.hasComparisonUnorderedLastMethod(type)) {
                missingOperators.put((Object)type, (Object)OperatorType.COMPARISON_UNORDERED_LAST);
            }
            if (!this.hasComparisonUnorderedFirstMethod(type)) {
                missingOperators.put((Object)type, (Object)OperatorType.COMPARISON_UNORDERED_FIRST);
            }
            if (!this.hasLessThanMethod(type)) {
                missingOperators.put((Object)type, (Object)OperatorType.LESS_THAN);
            }
            if (this.hasLessThanOrEqualMethod(type)) continue;
            missingOperators.put((Object)type, (Object)OperatorType.LESS_THAN_OR_EQUAL);
        }
        if (!missingOperators.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Type type : missingOperatorDeclaration) {
                messages.add(String.format("%s types operators is null", type));
            }
            for (Type type : missingOperators.keySet()) {
                messages.add(String.format("%s missing for %s", missingOperators.get((Object)type), type));
            }
            throw new IllegalStateException(Joiner.on((String)", ").join(messages));
        }
    }

    private boolean hasEqualMethod(Type type) {
        try {
            this.typeOperators.getEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasHashCodeMethod(Type type) {
        try {
            this.typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasXxHash64Method(Type type) {
        try {
            this.typeOperators.getXxHash64Operator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasIdenticalMethod(Type type) {
        try {
            this.typeOperators.getIdenticalOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasIndeterminateMethod(Type type) {
        try {
            this.typeOperators.getIndeterminateOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasComparisonUnorderedLastMethod(Type type) {
        try {
            this.typeOperators.getComparisonUnorderedLastOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private boolean hasComparisonUnorderedFirstMethod(Type type) {
        try {
            this.typeOperators.getComparisonUnorderedFirstOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private boolean hasLessThanMethod(Type type) {
        try {
            this.typeOperators.getLessThanOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private boolean hasLessThanOrEqualMethod(Type type) {
        try {
            this.typeOperators.getLessThanOrEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private static final class InternalTypeManager
    implements TypeManager {
        private final TypeRegistry typeRegistry;
        private final TypeOperators typeOperators;

        @Inject
        public InternalTypeManager(TypeRegistry typeRegistry, TypeOperators typeOperators) {
            this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null");
            this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        }

        public Type getType(TypeSignature signature) {
            return this.typeRegistry.getType(signature);
        }

        public Type fromSqlType(String type) {
            return this.typeRegistry.fromSqlType(type);
        }

        public Type getType(TypeId id) {
            return this.typeRegistry.getType(id);
        }

        public TypeOperators getTypeOperators() {
            return this.typeOperators;
        }
    }
}

