/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public class DriverYieldSignal {
    @GuardedBy(value="this")
    private long runningSequence;
    @GuardedBy(value="this")
    private boolean terminationStarted;
    @GuardedBy(value="this")
    private ScheduledFuture<?> yieldFuture;
    private final AtomicBoolean yield = new AtomicBoolean();

    public synchronized void setWithDelay(long maxRunNanos, ScheduledExecutorService executor) {
        Preconditions.checkState((this.yieldFuture == null ? 1 : 0) != 0, (Object)"there is an ongoing yield");
        Preconditions.checkState((!this.isSet() ? 1 : 0) != 0, (Object)"yield while driver was not running");
        if (this.terminationStarted) {
            return;
        }
        ++this.runningSequence;
        long expectedRunningSequence = this.runningSequence;
        this.yieldFuture = executor.schedule(() -> {
            DriverYieldSignal driverYieldSignal = this;
            synchronized (driverYieldSignal) {
                if (expectedRunningSequence == this.runningSequence && this.yieldFuture != null) {
                    this.yield.set(true);
                }
            }
        }, maxRunNanos, TimeUnit.NANOSECONDS);
    }

    public synchronized void reset() {
        if (this.terminationStarted) {
            return;
        }
        Preconditions.checkState((this.yieldFuture != null ? 1 : 0) != 0, (Object)"there is no ongoing yield");
        this.yield.set(false);
        this.yieldFuture.cancel(true);
        this.yieldFuture = null;
    }

    public boolean isSet() {
        return this.yield.get();
    }

    public synchronized void yieldImmediatelyForTermination() {
        this.terminationStarted = true;
        this.yield.set(true);
        if (this.yieldFuture != null) {
            this.yieldFuture.cancel(true);
            this.yieldFuture = null;
        }
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("yieldScheduled", this.yieldFuture != null).add("yield", this.yield.get()).toString();
    }

    @VisibleForTesting
    public synchronized void forceYieldForTesting() {
        this.yield.set(true);
    }

    @VisibleForTesting
    public synchronized void resetYieldForTesting() {
        this.yield.set(false);
    }
}

