/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.IntFunction;

public final class IdRegistry<T> {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(IdRegistry.class);
    private final ObjectList<T> objects = new ObjectList();
    private final IntFIFOQueue emptySlots = new IntFIFOQueue();

    public T allocateId(IntFunction<T> factory) {
        T result;
        if (!this.emptySlots.isEmpty()) {
            int id = this.emptySlots.dequeueInt();
            result = factory.apply(id);
            this.objects.set(id, result);
        } else {
            result = factory.apply(this.objects.size());
            this.objects.add(result);
        }
        return result;
    }

    public void deallocate(int id) {
        this.objects.set(id, null);
        this.emptySlots.enqueue(id);
    }

    public T get(int id) {
        return (T)this.objects.get(id);
    }

    public long sizeOf() {
        return INSTANCE_SIZE + this.objects.sizeOf() + this.emptySlots.sizeOf();
    }

    private static class ObjectList<T>
    extends ObjectArrayList<T> {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(ObjectList.class);

        private ObjectList() {
        }

        public long sizeOf() {
            return INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.a);
        }
    }

    private static class IntFIFOQueue
    extends IntArrayFIFOQueue {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(IntFIFOQueue.class);

        private IntFIFOQueue() {
        }

        public long sizeOf() {
            return INSTANCE_SIZE + SizeOf.sizeOf((int[])this.array);
        }
    }
}

