/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.PagesWindowIndex;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class OrderedWindowAccumulator
implements WindowAccumulator {
    private final PagesIndex.Factory pagesIndexFactory;
    private final PagesIndex pagesIndex;
    private final List<Type> argumentTypes;
    private final List<Integer> argumentChannels;
    private final List<Integer> sortKeysArguments;
    private final List<SortOrder> sortOrders;
    private WindowAccumulator delegate;
    private final WindowAccumulator initialDelegate;
    private PageBuilder pageBuilder;
    private boolean pagesIndexSorted;

    public OrderedWindowAccumulator(PagesIndex.Factory pagesIndexFactory, WindowAccumulator delegate, List<Type> argumentTypes, List<Integer> argumentChannels, List<Integer> sortKeysArguments, List<SortOrder> sortOrders) {
        this(pagesIndexFactory, pagesIndexFactory.newPagesIndex(argumentTypes, 10000), delegate, argumentTypes, argumentChannels, sortKeysArguments, sortOrders);
    }

    private OrderedWindowAccumulator(PagesIndex.Factory pagesIndexFactory, PagesIndex pagesIndex, WindowAccumulator delegate, List<Type> argumentTypes, List<Integer> argumentChannels, List<Integer> sortKeysArguments, List<SortOrder> sortOrders) {
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.pagesIndex = Objects.requireNonNull(pagesIndex, "pagesIndex is null");
        Objects.requireNonNull(argumentTypes, "argumentTypes is null");
        Objects.requireNonNull(argumentChannels, "argumentChannels is null");
        Preconditions.checkArgument((argumentTypes.size() == argumentChannels.size() ? 1 : 0) != 0, (Object)"argumentTypes and argumentChannels must have the same size");
        this.argumentTypes = ImmutableList.copyOf(argumentTypes);
        this.argumentChannels = ImmutableList.copyOf(argumentChannels);
        Objects.requireNonNull(sortOrders, "sortOrders is null");
        Objects.requireNonNull(sortKeysArguments, "sortChannels is null");
        Preconditions.checkArgument((sortOrders.size() == sortKeysArguments.size() ? 1 : 0) != 0, (Object)"sortOrders and sortChannels must have the same size");
        sortKeysArguments.forEach(argument -> Preconditions.checkArgument((argument < argumentChannels.size() ? 1 : 0) != 0, (String)"invalid argument %s referenced; total number of arguments is %s", (Object)argument, (int)argumentChannels.size()));
        this.sortOrders = ImmutableList.copyOf(sortOrders);
        this.sortKeysArguments = ImmutableList.copyOf(sortKeysArguments);
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.initialDelegate = delegate.copy();
        this.pageBuilder = new PageBuilder(argumentTypes);
    }

    public long getEstimatedSize() {
        return this.delegate.getEstimatedSize() + this.initialDelegate.getEstimatedSize() + this.pagesIndex.getEstimatedSize().toBytes() + this.pageBuilder.getRetainedSizeInBytes();
    }

    public WindowAccumulator copy() {
        PagesIndex pagesIndexCopy = this.pagesIndexFactory.newPagesIndex(this.argumentTypes, this.pagesIndex.getPositionCount());
        this.pagesIndex.getPages().forEachRemaining(pagesIndexCopy::addPage);
        return new OrderedWindowAccumulator(this.pagesIndexFactory, pagesIndexCopy, this.delegate.copy(), this.argumentTypes, this.argumentChannels, this.sortKeysArguments, this.sortOrders);
    }

    public void addInput(WindowIndex index, int startPosition, int endPosition) {
        if (this.pagesIndexSorted) {
            this.pagesIndexSorted = false;
            this.delegate = this.initialDelegate.copy();
        }
        for (int position = startPosition; position <= endPosition; ++position) {
            if (this.pageBuilder.isFull()) {
                this.indexCurrentPage();
            }
            for (int channel = 0; channel < this.argumentChannels.size(); ++channel) {
                ValueBlock value = index.getSingleValueBlock(channel, position).getSingleValueBlock(0);
                this.pageBuilder.getBlockBuilder(channel).append(value, 0);
            }
            this.pageBuilder.declarePosition();
        }
    }

    private void indexCurrentPage() {
        this.pagesIndex.addPage(this.pageBuilder.build());
        this.pageBuilder.reset();
    }

    public void output(BlockBuilder blockBuilder) {
        if (!this.pagesIndexSorted) {
            int positionCount;
            if (!this.pageBuilder.isEmpty()) {
                this.indexCurrentPage();
            }
            if ((positionCount = this.pagesIndex.getPositionCount()) == 0) {
                this.delegate.output(blockBuilder);
                return;
            }
            this.pagesIndex.sort(this.sortKeysArguments, this.sortOrders);
            PagesWindowIndex sortedWindowIndex = new PagesWindowIndex(this.pagesIndex, 0, positionCount);
            this.delegate.addInput((WindowIndex)sortedWindowIndex, 0, positionCount - 1);
            this.pagesIndexSorted = true;
        }
        Preconditions.checkState((boolean)this.pageBuilder.isEmpty());
        this.delegate.output(blockBuilder);
    }
}

