/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.trino.operator.Operator;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.spi.Page;
import java.util.Objects;
import java.util.function.Consumer;

public class LocalExchangeSink {
    private final LocalExchanger exchanger;
    private final Consumer<LocalExchangeSink> onFinish;
    private final SettableFuture<Void> finished = SettableFuture.create();

    public static LocalExchangeSink finishedLocalExchangeSink() {
        LocalExchangeSink finishedSink = new LocalExchangeSink(LocalExchanger.FINISHED, sink -> {});
        finishedSink.finish();
        return finishedSink;
    }

    public LocalExchangeSink(LocalExchanger exchanger, Consumer<LocalExchangeSink> onFinish) {
        this.exchanger = Objects.requireNonNull(exchanger, "exchanger is null");
        this.onFinish = Objects.requireNonNull(onFinish, "onFinish is null");
    }

    public void finish() {
        if (this.finished.set(null)) {
            this.exchanger.finish();
            this.onFinish.accept(this);
        }
    }

    public ListenableFuture<Void> isFinished() {
        return this.finished;
    }

    public void addPage(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (this.isFinished().isDone()) {
            return;
        }
        this.exchanger.accept(page);
    }

    public ListenableFuture<Void> waitForWriting() {
        if (this.isFinished().isDone()) {
            return Operator.NOT_BLOCKED;
        }
        return this.exchanger.waitForWriting();
    }
}

