/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CastDependency;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

public final class ArrayJoin {
    private static final String NAME = "array_join";
    private static final String DESCRIPTION = "Concatenates the elements of the given array using a delimiter and an optional string to replace nulls";

    private ArrayJoin() {
    }

    @ScalarFunction(value="array_join")
    @Description(value="Concatenates the elements of the given array using a delimiter and an optional string to replace nulls")
    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="varchar")
    public static Slice arrayJoin(@CastDependency(fromType="E", toType="varchar", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, session=true)) MethodHandle castFunction, ConnectorSession session, @SqlType(value="array(E)") Block array, @SqlType(value="varchar") Slice delimiter) {
        return ArrayJoin.arrayJoin(castFunction, session, array, delimiter, null);
    }

    @ScalarFunction(value="array_join")
    @Description(value="Concatenates the elements of the given array using a delimiter and an optional string to replace nulls")
    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="varchar")
    public static Slice arrayJoin(@CastDependency(fromType="E", toType="varchar", convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, session=true)) MethodHandle castFunction, ConnectorSession session, @SqlType(value="array(E)") Block array, @SqlType(value="varchar") Slice delimiter, @SqlType(value="varchar") Slice nullReplacement) {
        int numElements = array.getPositionCount();
        Slice slices = new Slice[numElements * 2];
        int sliceIndex = 0;
        for (int arrayIndex = 0; arrayIndex < numElements; ++arrayIndex) {
            Slice value = null;
            if (!array.isNull(arrayIndex)) {
                try {
                    value = castFunction.invokeExact(session, array, arrayIndex);
                }
                catch (Throwable throwable) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error casting array element to VARCHAR", throwable);
                }
            }
            if (value == null) {
                if (nullReplacement == null) continue;
                value = nullReplacement;
            }
            if (sliceIndex > 0) {
                slices[sliceIndex++] = delimiter;
            }
            slices[sliceIndex++] = value;
        }
        int totalSize = 0;
        for (Slice slice : slices) {
            if (slice == null) break;
            totalSize += slice.length();
        }
        Slice result = Slices.allocate((int)totalSize);
        int offset = 0;
        for (Slice slice : slices) {
            if (slice == null) break;
            result.setBytes(offset, slice);
            offset += slice.length();
        }
        return result;
    }
}

