/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_max")
@Description(value="Get maximum value of array")
public final class ArrayMaxFunction {
    private ArrayMaxFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Object arrayMax(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareMethodHandle, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle readValue, @SqlType(value="array(T)") Block block) throws Throwable {
        int selectedPosition = -1;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                return null;
            }
            if (selectedPosition >= 0 && compareMethodHandle.invokeExact(block, position, block, selectedPosition) <= 0L) continue;
            selectedPosition = position;
        }
        if (selectedPosition < 0) {
            return null;
        }
        return readValue.invoke(block, selectedPosition);
    }
}

