/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;

@Description(value="Returns the position of the first occurrence of the given value in array (or 0 if not found)")
@ScalarFunction(value="array_position")
public final class ArrayPositionFunction {
    private ArrayPositionFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") boolean element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            try {
                Boolean result = equalMethodHandle.invokeExact(array, i, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") long element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            try {
                Boolean result = equalMethodHandle.invokeExact(array, i, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") double element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            try {
                Boolean result = equalMethodHandle.invokeExact(array, i, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Object element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            try {
                Boolean result = equalMethodHandle.invoke(array, i, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    private static void checkNotIndeterminate(Boolean equalsResult) {
        if (equalsResult == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "array_position does not support arrays with elements that are null or contain null");
        }
    }
}

