/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ArrayConcatUtils;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.block.Block;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayToElementConcatFunction
extends SqlScalarFunction {
    public static final ArrayToElementConcatFunction ARRAY_TO_ELEMENT_CONCAT_FUNCTION = new ArrayToElementConcatFunction();
    private static final String FUNCTION_NAME = "concat";
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArrayConcatUtils.class, "appendElement", Type.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArrayConcatUtils.class, "appendElement", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArrayConcatUtils.class, "appendElement", Type.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArrayConcatUtils.class, "appendElement", Type.class, Block.class, Slice.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArrayConcatUtils.class, "appendElement", Type.class, Block.class, Object.class);

    public ArrayToElementConcatFunction() {
        super(FunctionMetadata.scalarBuilder((String)FUNCTION_NAME).signature(Signature.builder().typeVariable("E").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("E", new TypeSignatureParameter[0])).build()).description("Concatenates an array to an element").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Type type = (Type)boundSignature.getArgumentTypes().get(1);
        MethodHandle methodHandle = type.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (type.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (type.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (type.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        methodHandle = methodHandle.bindTo(type);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }
}

