/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.lambda.LambdaFunctionInterface;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class InvokeFunction
extends SqlScalarFunction {
    public static final InvokeFunction INVOKE_FUNCTION = new InvokeFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(InvokeFunction.class, "invoke", InvokeLambda.class);

    private InvokeFunction() {
        super(FunctionMetadata.scalarBuilder((String)"invoke").signature(Signature.builder().typeVariable("T").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[0])).build()).nullable().hidden().description("lambda invoke function").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Type returnType = boundSignature.getReturnType();
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Class<?>>)ImmutableList.of(InvokeLambda.class), METHOD_HANDLE.asType(METHOD_HANDLE.type().changeReturnType(Primitives.wrap((Class)returnType.getJavaType()))), Optional.empty());
    }

    public static Object invoke(InvokeLambda function) {
        return function.apply();
    }

    @FunctionalInterface
    public static interface InvokeLambda
    extends LambdaFunctionInterface {
        public Object apply();
    }
}

