/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.json.JsonInputErrorNode;
import io.trino.json.ir.SqlJsonLiteralConverter;
import io.trino.json.ir.TypedValue;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlRow;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.type.Json2016Type;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class JsonArrayFunction
extends SqlScalarFunction {
    public static final JsonArrayFunction JSON_ARRAY_FUNCTION = new JsonArrayFunction();
    public static final String JSON_ARRAY_FUNCTION_NAME = "$json_array";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonArrayFunction.class, "jsonArray", RowType.class, SqlRow.class, Boolean.TYPE);
    private static final JsonNode EMPTY_ARRAY = new ArrayNode(JsonNodeFactory.instance);

    private JsonArrayFunction() {
        super(FunctionMetadata.scalarBuilder((String)JSON_ARRAY_FUNCTION_NAME).signature(Signature.builder().typeVariable("E").returnType(new TypeSignature("json2016", new TypeSignatureParameter[0])).argumentTypes((List)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0]), (Object)new TypeSignature("boolean", new TypeSignatureParameter[0]))).build()).argumentNullability(new boolean[]{true, false}).hidden().description("Creates a JSON array from elements").build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        RowType elementsRowType = (RowType)boundSignature.getArgumentType(0);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(elementsRowType);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static JsonNode jsonArray(RowType elementsRowType, SqlRow elementsRow, boolean nullOnNull) {
        if (ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)elementsRowType)) {
            return EMPTY_ARRAY;
        }
        int rawIndex = elementsRow.getRawIndex();
        ImmutableList.Builder arrayElements = ImmutableList.builder();
        for (int i = 0; i < elementsRowType.getFields().size(); ++i) {
            NullNode elementNode;
            Type elementType = ((RowType.Field)elementsRowType.getFields().get(i)).getType();
            Object element = TypeUtils.readNativeValue((Type)elementType, (Block)elementsRow.getRawFieldBlock(i), (int)rawIndex);
            Preconditions.checkState((!JsonInputErrorNode.JSON_ERROR.equals(element) ? 1 : 0) != 0, (Object)"malformed JSON error suppressed in the input function");
            if (element == null) {
                if (!nullOnNull) continue;
                elementNode = NullNode.getInstance();
            } else {
                elementNode = elementType.equals((Object)Json2016Type.JSON_2016) ? (JsonNode)element : SqlJsonLiteralConverter.getJsonNode(TypedValue.fromValueAsObject(elementType, element)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "value passed to JSON_ARRAY function cannot be converted to JSON"));
            }
            arrayElements.add((Object)elementNode);
        }
        return new ArrayNode(JsonNodeFactory.instance, (List)arrayElements.build());
    }
}

